/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.couriers;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.jboss.internal.soa.esb.couriers.DeliverOnlyCourier;
import org.jboss.internal.soa.esb.couriers.PickUpOnlyCourier;
import org.jboss.internal.soa.esb.couriers.helpers.JDBCEprDBResourceFactory;
import org.jboss.internal.soa.esb.util.StreamUtils;
import org.jboss.soa.esb.addressing.Call;
import org.jboss.soa.esb.addressing.eprs.JDBCEpr;
import org.jboss.soa.esb.common.TransactionStrategy;
import org.jboss.soa.esb.common.TransactionStrategyException;
import org.jboss.soa.esb.couriers.CourierException;
import org.jboss.soa.esb.couriers.CourierTimeoutException;
import org.jboss.soa.esb.couriers.CourierTransportException;
import org.jboss.soa.esb.couriers.FaultMessageException;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.util.Util;

public class SqlTableCourier
implements PickUpOnlyCourier,
DeliverOnlyCourier {
    protected long _pollLatency = 200L;
    protected long _sleepForRetries = 3000L;
    protected boolean deleteOnSuccess;
    protected boolean deleteOnError;
    protected boolean _isReceiver;
    private int messageType = 1111;
    private JDBCEprDBResourceFactory jdbcFactory;
    protected static Logger _logger = Logger.getLogger(SqlTableCourier.class);

    SqlTableCourier(JDBCEpr epr) throws CourierException {
        this(epr, false);
    }

    SqlTableCourier(JDBCEpr epr, boolean isReceiver) throws CourierException {
        this._isReceiver = isReceiver;
        this._sleepForRetries = 3000L;
        this.deleteOnSuccess = Boolean.TRUE.equals(Boolean.valueOf(epr.getPostDelete()));
        this.deleteOnError = Boolean.TRUE.equals(Boolean.valueOf(epr.getErrorDelete()));
        this.jdbcFactory = new JDBCEprDBResourceFactory(epr);
    }

    public void cleanup() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deliver(Message message) throws CourierException {
        Serializable serializedMessage;
        String msgId;
        if (this._isReceiver) {
            throw new CourierException("This is a read-only Courier");
        }
        if (null == message) {
            return false;
        }
        Call call = message.getHeader().getCall();
        if (null == call) {
            call = new Call();
            message.getHeader().setCall(call);
        }
        try {
            if (null == call.getMessageID()) {
                call.setMessageID(new URI(UUID.randomUUID().toString()));
            }
            msgId = call.getMessageID().toString();
        }
        catch (URISyntaxException e) {
            throw new CourierException("Problems with message header ", e);
        }
        boolean transactional = this.isTransactional();
        try {
            serializedMessage = Util.serialize(message);
        }
        catch (Exception e) {
            throw new CourierTransportException("Unable to serialize ESB Message.", e);
        }
        Connection connection = this.jdbcFactory.createConnection(transactional);
        try {
            PreparedStatement insertStatement = this.jdbcFactory.createInsertStatement(connection);
            try {
                insertStatement.setString(1, msgId);
                int n = this.getMessageType(connection);
                switch (n) {
                    case 2004: {
                        byte[] blobData = serializedMessage.toString().getBytes();
                        ByteArrayInputStream bais = new ByteArrayInputStream(blobData);
                        insertStatement.setBinaryStream(2, (InputStream)bais, blobData.length);
                        break;
                    }
                    case -4: 
                    case -3: 
                    case -2: {
                        byte[] data = serializedMessage.toString().getBytes();
                        insertStatement.setBytes(2, data);
                        break;
                    }
                    case 2005: {
                        String clobData = serializedMessage.toString();
                        StringReader clobReader = new StringReader(clobData);
                        insertStatement.setCharacterStream(2, (Reader)clobReader, clobData.length());
                        break;
                    }
                    case -1: 
                    case 1: 
                    case 12: {
                        insertStatement.setString(2, serializedMessage.toString());
                        break;
                    }
                    default: {
                        insertStatement.setObject(2, serializedMessage);
                    }
                }
                insertStatement.setString(3, State.Pending.getColumnValue());
                insertStatement.setLong(4, System.currentTimeMillis());
                insertStatement.executeUpdate();
            }
            finally {
                insertStatement.close();
            }
            if (!transactional) {
                connection.commit();
            }
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            try {
                if (!transactional) {
                    connection.rollback();
                }
            }
            catch (Exception exception) {
                _logger.debug((Object)exception);
            }
            _logger.debug((Object)"SQL exception during deliver", (Throwable)e);
            throw new CourierTransportException(e);
        }
        finally {
            try {
                if (!transactional) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                _logger.error((Object)"Exception while closing DataSource connection.", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message pickup(long millis) throws CourierException, CourierTimeoutException {
        Message result = null;
        long limit = System.currentTimeMillis() + (millis < 100L ? 100L : millis);
        do {
            boolean transactional = this.isTransactional();
            Connection connection = this.jdbcFactory.createConnection(transactional);
            try {
                PreparedStatement listStatement = this.jdbcFactory.createListStatement(connection);
                try {
                    ResultSet resultSet = listStatement.executeQuery();
                    try {
                        while (true) {
                            if (resultSet.next()) {
                                String messageId = resultSet.getString(1);
                                result = this.tryToPickup(messageId, connection);
                                if (!transactional) {
                                    connection.commit();
                                }
                                if (result == null) continue;
                                Message message = result;
                                return message;
                                continue;
                            }
                            break;
                        }
                    }
                    finally {
                        try {
                            resultSet.close();
                        }
                        catch (Exception e) {
                            _logger.warn((Object)"SQL Exception closing ResultSet", (Throwable)e);
                        }
                    }
                }
                finally {
                    try {
                        listStatement.close();
                    }
                    catch (Exception e) {
                        _logger.warn((Object)"SQL Exception closing PreparedStatement", (Throwable)e);
                    }
                }
            }
            catch (FaultMessageException e) {
                throw e;
            }
            catch (Exception e) {
                _logger.warn((Object)"Exception during pickup", (Throwable)e);
                if (!transactional) {
                    try {
                        connection.rollback();
                    }
                    catch (SQLException e1) {
                        _logger.warn((Object)"SQL Exception during rollback", (Throwable)e);
                    }
                }
                throw new CourierTransportException(e);
            }
            finally {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    _logger.warn((Object)"Error closing DataSource Connection.", (Throwable)e);
                }
            }
            try {
                long lSleep = limit - System.currentTimeMillis();
                if (this._pollLatency < lSleep) {
                    lSleep = this._pollLatency;
                }
                if (lSleep <= 0L) continue;
                Thread.sleep(lSleep);
            }
            catch (InterruptedException e) {
                return null;
            }
        } while (System.currentTimeMillis() <= limit);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message tryToPickup(String messageId, Connection connection) throws CourierException, SQLException {
        block31: {
            PreparedStatement selectUpdateStatement = this.jdbcFactory.createSelect4UpdateStatement(connection);
            try {
                selectUpdateStatement.setString(1, messageId);
                selectUpdateStatement.setString(2, State.Pending.getColumnValue());
                ResultSet resultSet = selectUpdateStatement.executeQuery();
                try {
                    if (!resultSet.next()) break block31;
                    Message result = null;
                    try {
                        Object value;
                        int type = this.getMessageType(resultSet);
                        switch (type) {
                            case 2004: {
                                byte[] blobData;
                                Blob blob = resultSet.getBlob(1);
                                byte[] byArray = blobData = blob != null ? StreamUtils.readStream(blob.getBinaryStream()) : null;
                                if (blobData != null) {
                                    value = new String(blobData);
                                    break;
                                }
                                value = "";
                                break;
                            }
                            case -4: 
                            case -3: 
                            case -2: {
                                byte[] binaryData = StreamUtils.readStream(resultSet.getBinaryStream(1));
                                value = new String(binaryData);
                                break;
                            }
                            case 2005: {
                                Clob clob = resultSet.getClob(1);
                                value = StreamUtils.readReader(clob.getCharacterStream());
                                break;
                            }
                            case -1: 
                            case 1: 
                            case 12: {
                                value = resultSet.getString(1);
                                break;
                            }
                            default: {
                                value = (Serializable)resultSet.getObject(1);
                            }
                        }
                        result = Util.deserialize((Serializable)value);
                    }
                    catch (Exception e) {
                        result = null;
                    }
                    finally {
                        if (result == null && this.deleteOnError) {
                            this.deleteMsg(messageId, connection);
                        } else if (result != null && this.deleteOnSuccess) {
                            this.deleteMsg(messageId, connection);
                        } else if (result == null) {
                            this.changeStatus(messageId, State.Error, connection);
                        } else {
                            this.changeStatus(messageId, State.Done, connection);
                        }
                    }
                    Message message = result;
                    return message;
                }
                finally {
                    try {
                        resultSet.close();
                    }
                    catch (Exception ex) {
                        _logger.warn((Object)"Could not close ResultSet.", (Throwable)ex);
                    }
                }
            }
            finally {
                selectUpdateStatement.close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteMsg(String messageId, Connection connection) throws SQLException {
        PreparedStatement statement = this.jdbcFactory.createDeleteStatement(connection);
        try {
            statement.setString(1, messageId);
            statement.executeUpdate();
        }
        finally {
            statement.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeStatus(String messageId, State to, Connection connection) throws SQLException {
        PreparedStatement statement = this.jdbcFactory.createUpdateStatusStatement(connection);
        try {
            statement.setString(1, to.getColumnValue());
            statement.setString(2, messageId);
            statement.executeUpdate();
        }
        finally {
            statement.close();
        }
    }

    public void setPollLatency(Long millis) {
        if (millis <= 200L) {
            _logger.warn((Object)("Poll latency must be >= 200 milliseconds - Keeping old value of " + this._pollLatency));
        } else {
            this._pollLatency = millis;
        }
    }

    private boolean isTransactional() throws CourierException {
        boolean transactional;
        try {
            TransactionStrategy txStrategy = TransactionStrategy.getTransactionStrategy(true);
            Object txHandle = txStrategy == null ? null : txStrategy.getTransaction();
            boolean isActive = txStrategy == null ? false : txStrategy.isActive();
            boolean bl = transactional = txHandle != null;
            if (transactional && !isActive) {
                throw new CourierException("Associated transaction is no longer active!");
            }
        }
        catch (TransactionStrategyException ex) {
            throw new CourierException(ex);
        }
        return transactional;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized int getMessageType(Connection connection) throws SQLException {
        if (this.messageType != 1111) {
            return this.messageType;
        }
        PreparedStatement ps = this.jdbcFactory.createSelect4UpdateStatement(connection);
        try {
            int n;
            ps.setString(1, "");
            ps.setString(2, State.Pending.getColumnValue());
            ResultSet resultSet = ps.executeQuery();
            try {
                n = this.getMessageType(resultSet);
            }
            catch (Throwable throwable) {
                try {
                    resultSet.close();
                }
                catch (Throwable th) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                resultSet.close();
            }
            catch (Throwable th) {
                // empty catch block
            }
            return n;
        }
        finally {
            try {
                ps.close();
            }
            catch (Throwable th) {}
        }
    }

    private synchronized int getMessageType(ResultSet resultSet) throws SQLException {
        if (this.messageType == 1111) {
            ResultSetMetaData metaData = resultSet.getMetaData();
            this.messageType = metaData.getColumnType(1);
        }
        return this.messageType;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        Pending,
        WorkInProgress,
        Done,
        Error;


        public String getColumnValue() {
            return this.toString().substring(0, 1);
        }
    }
}

