/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.couriers;

import java.io.IOException;
import java.util.List;
import java.util.Properties;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.jboss.internal.soa.esb.couriers.DeliverOnlyCourier;
import org.jboss.internal.soa.esb.couriers.PickUpOnlyCourier;
import org.jboss.internal.soa.esb.couriers.helpers.JmsComposer;
import org.jboss.internal.soa.esb.rosetta.pooling.ConnectionException;
import org.jboss.internal.soa.esb.rosetta.pooling.JmsConnectionPool;
import org.jboss.internal.soa.esb.rosetta.pooling.JmsConnectionPoolContainer;
import org.jboss.internal.soa.esb.rosetta.pooling.JmsSession;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.addressing.MalformedEPRException;
import org.jboss.soa.esb.addressing.eprs.JMSEpr;
import org.jboss.soa.esb.couriers.CourierException;
import org.jboss.soa.esb.couriers.CourierMarshalUnmarshalException;
import org.jboss.soa.esb.couriers.CourierServiceBindException;
import org.jboss.soa.esb.couriers.CourierTimeoutException;
import org.jboss.soa.esb.couriers.CourierTransportException;
import org.jboss.soa.esb.helpers.KeyValuePair;
import org.jboss.soa.esb.helpers.NamingContextException;
import org.jboss.soa.esb.helpers.NamingContextPool;
import org.jboss.soa.esb.listeners.gateway.DefaultESBPropertiesSetter;
import org.jboss.soa.esb.listeners.gateway.ESBPropertiesSetter;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.notification.jms.DefaultJMSPropertiesSetter;
import org.jboss.soa.esb.notification.jms.JMSPropertiesSetter;
import org.jboss.soa.esb.util.Util;

public class JmsCourier
implements PickUpOnlyCourier,
DeliverOnlyCourier {
    long _sleepForRetries = 3000L;
    protected boolean _isReceiver;
    protected JMSEpr _epr;
    protected Logger _logger = Logger.getLogger(JmsCourier.class);
    protected String _messageSelector;
    protected JmsSession jmsSession;
    protected MessageProducer _messageProducer;
    protected MessageConsumer _messageConsumer;
    protected List<KeyValuePair> _messageProperties;
    protected JmsConnectionPool jmsConnectionPool;
    private JMSPropertiesSetter jmsPropertiesStrategy = new DefaultJMSPropertiesSetter();
    private ESBPropertiesSetter esbPropertiesStrategy = new DefaultESBPropertiesSetter();

    public JmsCourier(JMSEpr epr) throws CourierException {
        this(epr, false);
    }

    public JmsCourier(JMSEpr epr, boolean isReceiver) throws CourierException {
        this._isReceiver = isReceiver;
        this._epr = epr;
        this._sleepForRetries = 3000L;
        if (!this._isReceiver) {
            try {
                this._messageProperties = Util.propertiesFromSelector(this._epr.getMessageSelector());
            }
            catch (Exception e) {
                throw new CourierException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        JmsCourier jmsCourier = this;
        synchronized (jmsCourier) {
            block18: {
                try {
                    if (this._messageProducer != null) {
                        try {
                            this._messageProducer.close();
                        }
                        catch (Exception e) {
                            this._logger.debug((Object)e.getMessage(), (Throwable)e);
                        }
                        finally {
                            this._messageProducer = null;
                        }
                    }
                    if (this._messageConsumer == null) break block18;
                    try {
                        this._messageConsumer.close();
                    }
                    catch (JMSException e) {
                        this._logger.debug((Object)e.getMessage(), (Throwable)e);
                    }
                    finally {
                        this._messageConsumer = null;
                    }
                }
                finally {
                    this.closeSession();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void closeSession() {
        if (this.jmsSession != null) {
            try {
                this.getConnectionPool().closeSession(this.jmsSession);
            }
            catch (ConnectionException e) {
                this._logger.error((Object)"Unable to get Connection Pool for closing of JMS Session.", (Throwable)e);
            }
            finally {
                this.jmsSession = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void releaseSession() {
        if (this.jmsSession != null) {
            try {
                this.getConnectionPool().releaseSession(this.jmsSession);
            }
            catch (ConnectionException e) {
                this._logger.error((Object)"Unable to get Connection Pool for releasing of JMS Session.", (Throwable)e);
            }
            finally {
                this.jmsSession = null;
            }
        }
    }

    public Session getJmsSession() throws CourierException {
        return this.getJmsSession(1);
    }

    public synchronized Session getJmsSession(int acknowledgeMode) throws CourierException {
        if (this.jmsSession == null) {
            try {
                this.jmsSession = this.getConnectionPool().getSession(acknowledgeMode);
            }
            catch (NamingException e) {
                throw new CourierServiceBindException("Failed to get JMS Session from pool.", e);
            }
            catch (JMSException e) {
                throw new CourierServiceBindException("Failed to get JMS Session from pool.", e);
            }
            catch (ConnectionException e) {
                throw new CourierServiceBindException("Failed to get JMS Session from pool.", e);
            }
        }
        return this.jmsSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deliver(Message message) throws CourierException {
        ObjectMessage msg;
        if (null == message) {
            return false;
        }
        JmsCourier jmsCourier = this;
        synchronized (jmsCourier) {
            if (this._messageProducer == null) {
                try {
                    this.createMessageProducer();
                }
                catch (NamingContextException nce) {
                    throw new CourierServiceBindException("Unexpected exception attempting to access naming context pool", nce);
                }
            }
        }
        try {
            msg = this.getJmsSession(this._epr.getAcknowledgeMode()).createObjectMessage(Util.serialize(message));
        }
        catch (JMSException e) {
            throw new CourierMarshalUnmarshalException("Failed to serialize ESB Message.", e);
        }
        catch (ParserConfigurationException e) {
            throw new CourierMarshalUnmarshalException("Failed to serialize ESB Message.", e);
        }
        catch (IOException e) {
            throw new CourierMarshalUnmarshalException("Failed to serialize ESB Message.", e);
        }
        try {
            this.setJMSProperties(message, (javax.jms.Message)msg);
        }
        catch (JMSException e) {
            throw new CourierMarshalUnmarshalException("Failed to set JMS Message properties from ESB Message properties.", e);
        }
        return this.deliver((javax.jms.Message)msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deliver(javax.jms.Message message) throws CourierException {
        if (this._isReceiver) {
            throw new CourierException("This is a read-only Courier");
        }
        if (null == message) {
            return false;
        }
        JmsCourier jmsCourier = this;
        synchronized (jmsCourier) {
            if (this._messageProducer == null) {
                try {
                    this.createMessageProducer();
                }
                catch (NamingContextException nce) {
                    throw new CourierServiceBindException("Unexpected exception attempting to access naming context pool", nce);
                }
            }
        }
        jmsCourier = this;
        synchronized (jmsCourier) {
            while (this._messageProducer != null) {
                try {
                    for (KeyValuePair kvp : this._messageProperties) {
                        String key = kvp.getKey();
                        if (message.getStringProperty(key) != null) continue;
                        message.setStringProperty(key, kvp.getValue());
                    }
                    this._messageProducer.send(message);
                    return true;
                }
                catch (JMSException e) {
                    if (this.jmsConnectRetry((Exception)((Object)e))) continue;
                    throw new CourierTransportException("Caught exception during delivery and could not reconnect! ", e);
                }
                catch (Exception e) {
                    throw new CourierException(e);
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jmsConnectRetry(Exception exc) {
        this._logger.debug((Object)"JMS error.  Attempting JMS reconnect.", (Throwable)exc);
        JmsCourier jmsCourier = this;
        synchronized (jmsCourier) {
            try {
                if (this.jmsSession != null && this.jmsSession.getTransacted()) {
                    this.jmsSession.rollback();
                    return false;
                }
                this.cleanup();
            }
            catch (JMSException jmse) {
                this.releaseSession();
                return false;
            }
            int maxRetry = 5;
            for (int i1 = 0; i1 < 5; ++i1) {
                try {
                    if (this._isReceiver) {
                        this.createMessageConsumer();
                        break;
                    }
                    this.createMessageProducer();
                    break;
                }
                catch (Exception e) {
                    if (i1 < 4) {
                        try {
                            Thread.sleep(this._sleepForRetries);
                            continue;
                        }
                        catch (InterruptedException e1) {
                            this._logger.debug((Object)"Unexpected thread interupt exception.", (Throwable)e);
                            break;
                        }
                    }
                    this._logger.debug((Object)"Failed to reconnect to JMS", (Throwable)e);
                    return false;
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createMessageProducer() throws CourierException, NamingContextException {
        JmsCourier jmsCourier = this;
        synchronized (jmsCourier) {
            if (this._messageProducer == null) {
                try {
                    Session session = this.getJmsSession(this._epr.getAcknowledgeMode());
                    Destination destination = null;
                    String destinationName = this._epr.getDestinationName();
                    Context oJndiCtx = NamingContextPool.getNamingContext(this._epr.getJndiEnvironment());
                    try {
                        String sType = this._epr.getDestinationType();
                        if ("queue".equals(sType)) {
                            try {
                                destination = (Destination)oJndiCtx.lookup(destinationName);
                            }
                            catch (NamingException ne) {
                                try {
                                    oJndiCtx = NamingContextPool.replaceNamingContext(oJndiCtx, this._epr.getJndiEnvironment());
                                    destination = (Destination)oJndiCtx.lookup(destinationName);
                                }
                                catch (NamingException nex) {
                                    destination = session.createQueue(destinationName);
                                }
                            }
                        } else if ("topic".equals(sType)) {
                            try {
                                destination = (Destination)oJndiCtx.lookup(destinationName);
                            }
                            catch (NamingException ne) {
                                destination = session.createTopic(destinationName);
                            }
                        } else {
                            throw new CourierException("Unknown destination type");
                        }
                        this._messageProducer = session.createProducer(destination);
                        this._messageProducer.setDeliveryMode(this._epr.getPersistent() ? 2 : 1);
                        if (this._logger.isDebugEnabled()) {
                            this._logger.debug((Object)("JMSCourier deliveryMode: " + this._messageProducer.getDeliveryMode() + ", peristent:" + this._epr.getPersistent()));
                        }
                    }
                    finally {
                        if (oJndiCtx != null) {
                            NamingContextPool.releaseNamingContext(oJndiCtx);
                        }
                    }
                }
                catch (JMSException ex) {
                    this._logger.debug((Object)"Error from JMS system.", (Throwable)ex);
                    throw new CourierException(ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JmsConnectionPool getConnectionPool() throws ConnectionException {
        JmsCourier jmsCourier = this;
        synchronized (jmsCourier) {
            if (this.jmsConnectionPool == null) {
                String sFactoryClass = this._epr.getConnectionFactory();
                Properties properties = this._epr.getJndiEnvironment();
                String username = this._epr.getJMSSecurityPrincipal();
                String password = this._epr.getJMSSecurityCredential();
                if (Util.isNullString(sFactoryClass)) {
                    sFactoryClass = "ConnectionFactory";
                }
                this.jmsConnectionPool = JmsConnectionPoolContainer.getPool(properties, sFactoryClass, username, password);
            }
            return this.jmsConnectionPool;
        }
    }

    public Message pickup(long millis) throws CourierException, CourierTimeoutException {
        javax.jms.Message jmsMessage = this.pickupPayload(millis);
        return JmsComposer.compose(jmsMessage, this.esbPropertiesStrategy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public javax.jms.Message pickupPayload(long millis) throws CourierException, CourierTimeoutException {
        if (!this._isReceiver) {
            throw new CourierException("This is an outgoing-only Courier");
        }
        if (millis < 1L) {
            throw new IllegalArgumentException("Timeout millis must be > 0");
        }
        JmsCourier jmsCourier = this;
        synchronized (jmsCourier) {
            if (null == this._messageConsumer) {
                try {
                    this.createMessageConsumer();
                }
                catch (Exception e) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException eI) {
                        // empty catch block
                    }
                    throw new CourierException("Unable to create Message Consumer", e);
                }
            }
        }
        javax.jms.Message jmsMessage = null;
        JmsCourier jmsCourier2 = this;
        synchronized (jmsCourier2) {
            while (null != this._messageConsumer) {
                try {
                    jmsMessage = this._messageConsumer.receive(millis);
                    break;
                }
                catch (JMSException e) {
                    if (this.jmsConnectRetry((Exception)((Object)e))) continue;
                    throw new CourierTransportException("Caught exception during receive and could not reconnect! ", e);
                }
                catch (Exception e) {
                    throw new CourierTransportException(e);
                }
            }
        }
        return jmsMessage;
    }

    public void setJmsPropertiesStrategy(JMSPropertiesSetter jmsPropertiesStrategy) {
        this.jmsPropertiesStrategy = jmsPropertiesStrategy;
    }

    public void setEsbPropertiesStrategy(ESBPropertiesSetter esbPropertiesStrategy) {
        this.esbPropertiesStrategy = esbPropertiesStrategy;
    }

    protected void setJMSProperties(Message fromESBMessage, javax.jms.Message toJMSMessage) throws JMSException {
        this.jmsPropertiesStrategy.setJMSProperties(fromESBMessage, toJMSMessage);
    }

    protected void setPropertiesFromJMSMessage(javax.jms.Message fromJMS, Message toESB) throws JMSException {
        this.esbPropertiesStrategy.setPropertiesFromJMSMessage(fromJMS, toESB);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createMessageConsumer() throws CourierException, ConfigurationException, MalformedEPRException, NamingContextException {
        Context oJndiCtx = null;
        JmsCourier jmsCourier = this;
        synchronized (jmsCourier) {
            if (this._messageConsumer == null) {
                boolean success = false;
                try {
                    Properties environment = this._epr.getJndiEnvironment();
                    Session session = this.getJmsSession(this._epr.getAcknowledgeMode());
                    Destination destination = null;
                    String destinationName = this._epr.getDestinationName();
                    oJndiCtx = NamingContextPool.getNamingContext(environment);
                    try {
                        String sType = this._epr.getDestinationType();
                        if ("queue".equals(sType)) {
                            try {
                                destination = (Destination)oJndiCtx.lookup(destinationName);
                            }
                            catch (NamingException ne) {
                                try {
                                    oJndiCtx = NamingContextPool.replaceNamingContext(oJndiCtx, environment);
                                    destination = (Destination)oJndiCtx.lookup(destinationName);
                                }
                                catch (NamingException nex) {
                                    destination = session.createQueue(destinationName);
                                }
                            }
                        } else if ("topic".equals(sType)) {
                            try {
                                destination = (Destination)oJndiCtx.lookup(destinationName);
                            }
                            catch (NamingException ne) {
                                destination = session.createTopic(destinationName);
                            }
                        } else {
                            throw new CourierException("Unknown destination type");
                        }
                        if (destination == null) {
                            throw new CourierException("Could not locate destination: " + destinationName);
                        }
                        this._messageConsumer = session.createConsumer(destination, this._epr.getMessageSelector());
                        success = true;
                    }
                    finally {
                        NamingContextPool.releaseNamingContext(oJndiCtx);
                    }
                }
                catch (JMSException ex) {
                    this._logger.debug((Object)"Error from JMS system.", (Throwable)ex);
                    throw new CourierException(ex);
                }
                finally {
                    if (!success) {
                        this.closeSession();
                    }
                }
            }
        }
    }
}

