/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.couriers;

import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.log4j.Logger;
import org.jboss.internal.soa.esb.couriers.DeliverOnlyCourier;
import org.jboss.internal.soa.esb.couriers.PickUpOnlyCourier;
import org.jboss.internal.soa.esb.couriers.tx.InVMXAResource;
import org.jboss.internal.soa.esb.message.format.MessageSerializer;
import org.jboss.soa.esb.addressing.eprs.InVMEpr;
import org.jboss.soa.esb.common.TransactionStrategy;
import org.jboss.soa.esb.common.TransactionStrategyException;
import org.jboss.soa.esb.couriers.CourierException;
import org.jboss.soa.esb.message.ByReferenceMessage;
import org.jboss.soa.esb.message.Message;

public class InVMCourier
implements PickUpOnlyCourier,
DeliverOnlyCourier {
    protected InVMEpr epr;
    protected static Logger logger = Logger.getLogger(InVMCourier.class);
    private Queue<Object> messageQueue = new ConcurrentLinkedQueue<Object>();
    private long deliveryTimeout = 0L;
    private boolean isActive = true;
    private boolean passByValue = true;

    public InVMCourier(InVMEpr epr) {
        this.epr = epr;
        this.deliveryTimeout = epr.getLockstep() ? epr.getLockstepWaitTime() : 0L;
        this.passByValue = epr.getPassByValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deliver(Message message) throws CourierException {
        this.isCourierActive();
        if (message == null) {
            return false;
        }
        try {
            Object addedObject;
            if (this.isTransactional()) {
                TransactionStrategy txStrategy = TransactionStrategy.getTransactionStrategy(true);
                txStrategy.enlistResource(new InVMXAResource(this, message, InVMXAResource.operation.INSERT));
                return true;
            }
            if (this.passByValue) {
                try {
                    addedObject = MessageSerializer.serialize(message);
                }
                catch (IOException ex) {
                    logger.warn((Object)"Could not serialize message to pass by value.", (Throwable)ex);
                    return false;
                }
            } else {
                addedObject = message instanceof ByReferenceMessage ? (Object)((ByReferenceMessage)message).reference() : (Object)message;
            }
            Queue<Object> queue = this.messageQueue;
            synchronized (queue) {
                this.messageQueue.add(addedObject);
                this.messageQueue.notify();
                if (this.deliveryTimeout > 0L) {
                    long start = System.currentTimeMillis();
                    while (this.messageQueue.contains(addedObject)) {
                        try {
                            this.messageQueue.wait(5L);
                        }
                        catch (InterruptedException e) {
                            logger.warn((Object)("Waiting delivery thread interupted while waiting on message pickup on InVM queue '" + this.epr.getAddr().getAddress() + "'.  Exiting pickup wait state."));
                            break;
                        }
                        if (System.currentTimeMillis() <= start + this.deliveryTimeout) continue;
                        logger.warn((Object)("Timeout expired while waiting on message pickup on InVM queue '" + this.epr.getAddr().getAddress() + "'."));
                        break;
                    }
                }
            }
            return true;
        }
        catch (Throwable ex) {
            logger.warn((Object)("InVMCourier delivery caught: " + ex));
            return false;
        }
    }

    private Object addMessageToQueue(Message message) {
        Object addedObject;
        if (this.passByValue) {
            try {
                addedObject = MessageSerializer.serialize(message);
                this.messageQueue.add(addedObject);
            }
            catch (IOException ex) {
                logger.warn((Object)"Could not serialize message to pass by value.", (Throwable)ex);
                return false;
            }
        } else {
            addedObject = message;
            this.messageQueue.add(message);
        }
        return addedObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message pickup(long millis) throws CourierException {
        this.isCourierActive();
        Message message = null;
        try {
            millis = Math.max(millis, 100L);
            Object messageObj = null;
            Queue<Object> queue = this.messageQueue;
            synchronized (queue) {
                if (this.messageQueue.isEmpty()) {
                    try {
                        this.messageQueue.wait(millis);
                    }
                    catch (InterruptedException e) {
                        logger.debug((Object)("Pickup thread '" + Thread.currentThread().getName() + "' interrupted while waiting on delivery notification or timeout."), (Throwable)e);
                    }
                }
                if (!this.messageQueue.isEmpty()) {
                    messageObj = this.messageQueue.remove();
                }
                this.messageQueue.notify();
            }
            message = messageObj instanceof byte[] ? MessageSerializer.deserialize((byte[])messageObj) : (Message)messageObj;
            if (message != null && this.isTransactional()) {
                TransactionStrategy txStrategy = TransactionStrategy.getTransactionStrategy(true);
                InVMXAResource theResource = new InVMXAResource(this, message, InVMXAResource.operation.REMOVE);
                txStrategy.enlistResource(theResource);
            }
        }
        catch (Throwable ex) {
            logger.warn((Object)("InVMCourier pickup caught: " + ex));
            return null;
        }
        return message;
    }

    public void cleanup() {
    }

    private void isCourierActive() throws CourierException {
        if (!this.isActive) {
            throw new CourierException("InVMCourier for EPR '" + this.epr.getAddr().getAddress() + "' is not active.  Cannot pickup/deliver on this courier.");
        }
    }

    public void setActive(boolean active) {
        this.isActive = active;
    }

    public void clean() {
    }

    public void reset() {
        try {
            if (this.isTransactional()) {
                logger.warn((Object)"InVMCourier reset called on transactional courier: ignoring reset for the sake of consistency!");
            } else {
                this.messageQueue.clear();
            }
        }
        catch (Throwable ex) {
            logger.debug((Object)("InVMCourier reset caught: " + ex));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doDeliver(Message message) {
        Queue<Object> queue = this.messageQueue;
        synchronized (queue) {
            Object addedObject = this.addMessageToQueue(message);
            if (addedObject == null) {
                return false;
            }
            this.messageQueue.notify();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doRedeliver(Message message) {
        Queue<Object> queue = this.messageQueue;
        synchronized (queue) {
            this.messageQueue.add(message);
        }
        return true;
    }

    private boolean isTransactional() throws CourierException {
        boolean transactional;
        try {
            TransactionStrategy txStrategy = TransactionStrategy.getTransactionStrategy(true);
            Object txHandle = txStrategy == null ? null : txStrategy.getTransaction();
            boolean isActive = txStrategy == null ? false : txStrategy.isActive();
            boolean bl = transactional = txHandle != null;
            if (transactional && !isActive) {
                throw new CourierException("Associated transaction is no longer active!");
            }
        }
        catch (TransactionStrategyException ex) {
            throw new CourierException(ex);
        }
        return transactional;
    }
}

