/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.couriers;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.UUID;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.jboss.internal.soa.esb.couriers.DeliverOnlyCourier;
import org.jboss.internal.soa.esb.couriers.PickUpOnlyCourier;
import org.jboss.internal.soa.esb.couriers.helpers.FileHandler;
import org.jboss.internal.soa.esb.couriers.helpers.FileHandlerFactory;
import org.jboss.internal.soa.esb.couriers.helpers.LocalFileHandler;
import org.jboss.soa.esb.addressing.Call;
import org.jboss.soa.esb.addressing.MalformedEPRException;
import org.jboss.soa.esb.addressing.eprs.FileEpr;
import org.jboss.soa.esb.common.ModulePropertyManager;
import org.jboss.soa.esb.couriers.CourierException;
import org.jboss.soa.esb.couriers.CourierMarshalUnmarshalException;
import org.jboss.soa.esb.couriers.CourierServiceBindException;
import org.jboss.soa.esb.couriers.CourierTimeoutException;
import org.jboss.soa.esb.couriers.CourierTransportException;
import org.jboss.soa.esb.couriers.CourierUtil;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.util.FileUtil;
import org.jboss.soa.esb.util.Util;

public class FileCourier
implements PickUpOnlyCourier,
DeliverOnlyCourier {
    protected long _pollLatency = 900L;
    protected static final String DEFAULT_TMP = System.getProperty("java.io.tmpdir");
    protected String _inputSuffix;
    protected URI _uri;
    protected boolean _receiverOnly;
    protected FileEpr _epr;
    protected LocalFileHandler _localFhandler;
    protected static Logger _logger = Logger.getLogger(FileCourier.class);

    protected FileCourier() {
    }

    FileCourier(FileEpr epr) throws CourierException, MalformedEPRException {
        this(epr, false);
    }

    FileCourier(FileEpr epr, boolean receiverOnly) throws CourierException, MalformedEPRException {
        this._receiverOnly = receiverOnly;
        this._epr = epr;
        this.checkEprParms();
    }

    protected void checkEprParms() throws CourierException, MalformedEPRException {
        this._inputSuffix = this._epr.getInputSuffix();
        _logger.debug((Object)("input suffix set to " + this._inputSuffix));
        try {
            this._uri = this._epr.getURI();
            FileHandler handler = FileHandlerFactory.getInstance().getFileHandler(this._epr);
            if (handler instanceof LocalFileHandler) {
                File directory;
                this._localFhandler = (LocalFileHandler)handler;
                File file = new File(this._uri);
                if (!this._receiverOnly && !file.isDirectory()) {
                    throw new CourierException("File for deliverAsync EPR must be a directory (file name will be MessageID)");
                }
                File file2 = directory = file.isDirectory() ? file : file.getParentFile();
                if (null == directory) {
                    directory = new File("");
                }
                if (!directory.canRead()) {
                    throw new CourierException("Can't read directory " + directory.toString());
                }
                if (!directory.canWrite()) {
                    throw new CourierException("Can't write in directory " + directory.toString());
                }
                return;
            }
        }
        catch (Exception e) {
            throw new MalformedEPRException(e);
        }
    }

    public boolean deliver(Message message) throws CourierException, MalformedEPRException {
        LocalFileHandler handler;
        if (this._receiverOnly) {
            throw new CourierException("This is a pickUp-only Courier");
        }
        if (null == message) {
            return false;
        }
        FileHandler fileHandler = handler = null != this._localFhandler ? this._localFhandler : FileHandlerFactory.getInstance().getFileHandler(this._epr);
        if (null == handler) {
            throw new CourierServiceBindException("Can't find appropriate file handler for " + this._uri.toASCIIString());
        }
        Call call = message.getHeader().getCall();
        if (null == call) {
            call = new Call();
            message.getHeader().setCall(call);
        }
        try {
            if (null == call.getMessageID()) {
                call.setMessageID(new URI(UUID.randomUUID().toString()));
            }
        }
        catch (URISyntaxException e) {
            throw new MalformedEPRException("Problems with message header ", e);
        }
        File tmpFile = null;
        if (handler instanceof LocalFileHandler) {
            try {
                File dir = new File(this._uri);
                String name = message.getHeader().getCall().getMessageID().toString();
                name = name + this._inputSuffix;
                tmpFile = CourierUtil.messageToLocalFile(dir, message);
                handler.renameFile(tmpFile, new File(dir, name));
                return true;
            }
            catch (CourierException e) {
                throw new CourierTransportException(e);
            }
            catch (IOException e) {
                throw new CourierMarshalUnmarshalException(e);
            }
            catch (ParserConfigurationException e) {
                throw new CourierException(e);
            }
        }
        tmpFile = null;
        try {
            Method upload = handler.getClass().getMethod("uploadFile", File.class);
            String sDir = ModulePropertyManager.getPropertyManager("transports").getProperty("org.jboss.soa.esb.ftp.localdir", DEFAULT_TMP);
            File dir = new File(sDir);
            String name = message.getHeader().getCall().getMessageID().toString();
            name = name + this._inputSuffix;
            tmpFile = CourierUtil.messageToLocalFile(dir, message);
            File messageFile = new File(dir, name);
            FileUtil.renameTo(tmpFile, messageFile);
            tmpFile = messageFile;
            upload.invoke((Object)handler, messageFile);
            boolean bl = true;
            return bl;
        }
        catch (IOException ex) {
            if (tmpFile == null) {
                throw new CourierMarshalUnmarshalException(ex);
            }
            throw new CourierTransportException(ex);
        }
        catch (Exception e) {
            throw new CourierException(e);
        }
        finally {
            if (null != tmpFile) {
                tmpFile.delete();
            }
        }
    }

    public Message pickup(long millis) throws CourierException, CourierTimeoutException {
        Message result = null;
        long limit = System.currentTimeMillis() + (millis < 100L ? 100L : millis);
        do {
            LocalFileHandler handler;
            File[] files;
            if (null != (files = (handler = null != this._localFhandler ? this._localFhandler : FileHandlerFactory.getInstance().getFileHandler(this._epr)).getFileList()) && files.length > 0) {
                File input = files[0];
                File work = this.workFile(input);
                handler.renameFile(input, work);
                try {
                    result = this.readOneMessage(handler, work);
                }
                catch (CourierException e) {
                    _logger.debug((Object)("FileCourier.pickup caught exception during readOneMessage: " + e));
                    if (null == this.errorFile(input)) {
                        handler.deleteFile(work);
                        continue;
                    }
                    handler.renameFile(work, this.errorFile(input));
                    continue;
                }
                File done = this.postFile(input);
                if (null == done) {
                    handler.deleteFile(work);
                } else {
                    handler.renameFile(work, done);
                }
                return result;
            }
            try {
                long lSleep = limit - System.currentTimeMillis();
                if (this._pollLatency < lSleep) {
                    lSleep = this._pollLatency;
                }
                if (lSleep <= 0L) continue;
                Thread.sleep(lSleep);
            }
            catch (InterruptedException e) {
                return null;
            }
        } while (System.currentTimeMillis() <= limit);
        return null;
    }

    private Message readOneMessage(FileHandler handler, File work) throws CourierException {
        if (handler instanceof LocalFileHandler) {
            try {
                return CourierUtil.messageFromLocalFile(work);
            }
            catch (FileNotFoundException ex) {
                throw new CourierTransportException(ex);
            }
            catch (IOException ex) {
                throw new CourierMarshalUnmarshalException(ex);
            }
            catch (CourierException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new CourierException(ex);
            }
        }
        File tmpFile = null;
        try {
            Method download = handler.getClass().getMethod("downloadFile", File.class);
            tmpFile = (File)download.invoke((Object)handler, work);
            Message message = CourierUtil.messageFromLocalFile(tmpFile);
            return message;
        }
        catch (FileNotFoundException ex) {
            throw new CourierTransportException(ex);
        }
        catch (IOException ex) {
            throw new CourierTransportException(ex);
        }
        catch (CourierException ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new CourierTransportException(e);
        }
        finally {
            if (null != tmpFile) {
                tmpFile.delete();
            }
        }
    }

    protected File workFile(File input) {
        String sfx = this._epr.getWorkSuffix();
        if (Util.isNullString(sfx)) {
            sfx = ".esbInProcess";
            _logger.debug((Object)("No valid work suffix found in EPR - using default of " + sfx));
        }
        return new File(input.toString() + sfx);
    }

    protected File errorFile(File input) {
        try {
            if (this._epr.getErrorDelete()) {
                return null;
            }
        }
        catch (Exception e) {
            _logger.warn((Object)"Problems in FileEpr", (Throwable)e);
        }
        String sfx = this._epr.getErrorSuffix();
        if (Util.isNullString(sfx)) {
            sfx = ".esbERROR";
            _logger.debug((Object)("No valid work suffix found in EPR - using default of " + sfx));
        }
        return new File(input.toString() + sfx);
    }

    protected File postFile(File input) {
        String sfx;
        String dir;
        try {
            if (this._epr.getPostDelete()) {
                return null;
            }
        }
        catch (Exception e) {
            _logger.warn((Object)"Problems in FileEpr", (Throwable)e);
        }
        String inputDir = new File(input.getAbsolutePath()).getParent();
        if (inputDir == null) {
            _logger.debug((Object)("Could not get parent directory for " + input));
            inputDir = "";
        }
        if (null == (dir = this._epr.getPostDirectory())) {
            dir = inputDir;
            _logger.debug((Object)("No valid post process directory found in EPR - using same as input (" + dir + ")"));
        }
        if (Util.isNullString(sfx = this._epr.getPostSuffix())) {
            if (dir == null) {
                _logger.error((Object)"No way to determine post process directory. Will use a default relative to cwd.");
            }
            if (dir.equals(inputDir)) {
                sfx = ".esbProcessed";
                _logger.debug((Object)("No valid post suffix found in EPR - using default of " + sfx));
            }
        }
        return new File(dir, input.getName() + sfx);
    }

    public void setPollLatency(Long millis) {
        if (millis <= 900L) {
            _logger.warn((Object)("Poll latency must be >= 900 milliseconds - Keeping old value of " + this._pollLatency));
        } else {
            this._pollLatency = millis;
        }
    }

    public void cleanup() {
    }
}

