/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.addressing.eprs;

import java.net.URISyntaxException;
import java.util.UUID;
import org.jboss.soa.esb.addressing.eprs.JMSEpr;
import org.jboss.soa.esb.util.Util;

public class DefaultJmsReplyToEpr
extends JMSEpr {
    public static final String REPLY_UUID_TAG = "jbossESBresponseUUID";

    public DefaultJmsReplyToEpr(JMSEpr epr) throws URISyntaxException {
        super(epr.getVersion(), epr.getDestinationType(), DefaultJmsReplyToEpr.replyDestinationName(epr), epr.getConnectionFactory(), epr.getJndiEnvironment(), DefaultJmsReplyToEpr.replySelector(epr), epr.getPersistent());
    }

    private static String replyDestinationName(JMSEpr toEpr) throws URISyntaxException {
        return toEpr.getDestinationName() + "_reply";
    }

    private static String replySelector(JMSEpr epr) throws URISyntaxException {
        StringBuilder sb = new StringBuilder();
        String oldSelector = epr.getMessageSelector();
        if (!Util.isNullString(oldSelector)) {
            sb.append(oldSelector).append(" AND ");
        }
        sb.append(REPLY_UUID_TAG).append("='").append(UUID.randomUUID().toString()).append("'");
        return sb.toString();
    }
}

