/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.addressing.eprs;

import java.net.URI;
import java.net.URISyntaxException;
import org.jboss.internal.soa.esb.couriers.InVMCourier;
import org.jboss.soa.esb.addressing.EPR;
import org.jboss.soa.esb.addressing.eprs.InVMEpr;
import org.jboss.soa.esb.couriers.CourierFactory;

public class DefaultInVMReplyToEpr
extends InVMEpr {
    private static ThreadLocal<InVMEpr> invmReplyToEPRTL = new ThreadLocal();

    public DefaultInVMReplyToEpr(InVMEpr epr) {
        super(DefaultInVMReplyToEpr.getThreadEPR());
    }

    private static EPR getThreadEPR() {
        InVMEpr threadEPR = invmReplyToEPRTL.get();
        if (threadEPR == null) {
            try {
                threadEPR = new InVMEpr(URI.create("invm://thread-" + Thread.currentThread().getId()));
                invmReplyToEPRTL.set(threadEPR);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Unexpected Exception creating replyTo InVMEpr.", e);
            }
        }
        InVMCourier threadCourier = CourierFactory.getInstance().getInVMCourier(threadEPR);
        threadCourier.reset();
        return threadEPR;
    }
}

