/*******************************************************************************
*    ALMA - Atacama Large Millimiter Array
*    (c) Associated Universities Inc., 2002 *
*    (c) European Southern Observatory, 2002
*    Copyright by ESO (in the framework of the ALMA collaboration)
*    and Cosylab 2002, All rights reserved
*
*    This library is free software; you can redistribute it and/or
*    modify it under the terms of the GNU Lesser General Public
*    License as published by the Free Software Foundation; either
*    version 2.1 of the License, or (at your option) any later version.
*
*    This library is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*    Lesser General Public License for more details.
*
*    You should have received a copy of the GNU Lesser General Public
*    License along with this library; if not, write to the Free Software
*    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*
*
*
* "@(#) $Id: acscourseMount2Impl.cpp,v 1.1 2004/01/28 11:38:34 bjeram Exp $"
*
*/
 
#include <isabellasmartLampImpl.h>

/* ----------------------------------------------------------------*/
smart_LampImpl::smart_LampImpl(PortableServer::POA_ptr poa, const ACE_CString &_name) :
    CharacteristicComponentImpl(poa, _name),
    m_state_p(0),
    m_colour_p(0),
    m_brightness_p(0)
{
    // ACS_TRACE is used for debugging purposes
    ACS_TRACE("::smart_LampImpl::smart_LampImpl");

    // properties
    // the property's name must be composed of the server's name and the
    //   property name.
    m_state_p = new ROdouble(_name+":state", getComponent());
    // if this property wasn't created properly, we destroy it and all 
    //   of this component's previous properties
    CHARACTERISTIC_COMPONENT_PROPERTY(state, m_state_p);
	
    m_colour_p = new ROstring(_name+":colour", getComponent());	
    CHARACTERISTIC_COMPONENT_PROPERTY(colour, m_colour_p);

    m_brightness_p = new RWdouble(_name+":brightness", getComponent());
    CHARACTERISTIC_COMPONENT_PROPERTY(brightness, m_brightness_p);

    cout << "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX" << endl;
    cout << "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX" << endl;
    cout << "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX" << endl;
    cout << "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX" << endl;
    cout << "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX" << endl;
    cout << "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX" << endl;
    cout << "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX" << endl;
    cout << "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX" << endl;
    cout << "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX" << endl;


}

/* ----------------------------------------------------------------*/
smart_LampImpl::~smart_LampImpl()
{
    // ACS_TRACE is used for debugging purposes
    ACS_TRACE("::smart_LampImpl::~smart_LampImpl");
    ACS_DEBUG_PARAM("::smart_LampImpl::~smart_LampImpl", "Destroying %s...", name());

    // stop threads
    if (getComponent() != 0)
	{
	getComponent()->stopAllThreads();
	}
    
    // properties
    if (m_state_p != 0) 
	{ 
	m_state_p->destroy(); 
	m_state_p = 0; 
	}
    if (m_colour_p != 0) 
	{ 
	m_colour_p->destroy(); 
	m_colour_p = 0; 
	}
    if (m_brightness_p != 0) 
	{ 
	m_brightness_p->destroy(); 
	m_brightness_p = 0; 
	}
}

/* --------------------- [ CORBA interface ] ----------------------*/
void smart_LampImpl::init ()
    throw (CORBA::SystemException)
{
    
    cout << "Smart Lamp initialised " << endl; 
}

void smart_LampImpl::on (const char *colour, CORBA::Double brightness)
	throw (CORBA::SystemException)
{
    int errcode;
    unsigned long long timestamp;

    cout << "Smart Lamp ON - Colour " << colour << " Brightness " << brightness << endl; 
    m_colour_p->getDevIO()->write(colour, errcode, timestamp);
    m_brightness_p->getDevIO()->write(brightness, errcode, timestamp);
    cout << "Done" << endl; 
    
}


void smart_LampImpl::off ()
	throw (CORBA::SystemException)
{
    cout << "Smart Lamp OFF " << endl; 
}


ACS::ROdouble_ptr 
smart_LampImpl::state ()
    throw (CORBA::SystemException)
{
    if (m_state_p == 0)
	{
	return ACS::ROdouble::_nil();
	}

    ACS::ROdouble_var prop = ACS::ROdouble::_narrow(m_state_p->getCORBAReference());
    return prop._retn();
}

ACS::ROstring_ptr smart_LampImpl::colour ()
    throw (CORBA::SystemException)
{
    if (m_colour_p == 0)
	{
	return ACS::ROstring::_nil();
	}

    ACS::ROstring_var prop = ACS::ROstring::_narrow(m_colour_p->getCORBAReference());
    return prop._retn();
}


ACS::RWdouble_ptr smart_LampImpl::brightness ()
    throw (CORBA::SystemException)
{
    if (m_brightness_p == 0)
	{
	return ACS::RWdouble::_nil();
	}

    ACS::RWdouble_var prop = ACS::RWdouble::_narrow(m_brightness_p->getCORBAReference());
    return prop._retn();
}

/* --------------- [ MACI DLL support functions ] -----------------*/
//#include <maciACSComponentDefines.h>
//MACI_DLL_SUPPORT_FUNCTIONS(smart_LampImpl)
/* ----------------------------------------------------------------*/


/*___oOo___*/


