#!/usr/bin/env python
from acspy.clients.simpleClient import PySimpleClient     # Import the acspy.PySimpleClient class
import ACSCOURSE_ASM                       # Import the Python CORBA stubs for ACSCOURSE_ASM
import ACS, ACS__POA                  # Import the Python CORBA stubs for BACI
from   omniORB.CORBA import TRUE, FALSE
from time import sleep

class MyMonitor(ACS__POA.CBdouble):
    '''This class defines method(s) that will be invoked asynchronously by the asm device'''
    #------------------------------------------------------------------------------
    def __init__ (self, propName = None): 
        if propName != None:
            self.propName = propName
        else:
            self.propName = "NoName"
    #------------------------------------------------------------------------------
    def __del__(self):
        '''Do nothing'''

    def working (self, value, completion, desc):
        '''
        Method that does all the real work.
        Parameters: value = the double we are interested in
                    completion = completion structure
                    desc = callback struct description
        '''
        print "Working: ", str(self.propName), " is ", str(value)
    #------------------------------------------------------------------------------
    def done (self, value, completion, desc):
        '''
        Invoked just before a monitor is destroyed.
        Parameters: value = the final value of the double we are interested in
                    completion = completion structure
                    desc = callback struct description
        '''
        print "Done: ", str(self.propName), " is ", str(value)

def negotiate (self, time_to_transmit, desc):
        '''For simplicities sake, we always return true. '''
        return TRUE
#------------------------------------------------------------------------------

simpleClient = PySimpleClient([])

try:
    asm = simpleClient.getComponent("ASM_CPP_LOOP")  #Get the ASM_CPP_LOOP asm device
    actTempProperty = asm._get_actTemp()  #Get the actTemp property
    cbMon = MyMonitor("actTemp")  #Create a callback monitor for the actTemp Property
    cbMonServant = cbMon._this()  #Activate the callback monitor 
    desc = ACS.CBDescIn(0L, 0L, 0L)  #Create the real monitor registered with ASM_CPP_LOOP
    actMon = actTempProperty.create_monitor(cbMonServant, desc)
    actMon.set_timer_trigger(10000000)  #Working method gets invoked once per second
    sleep(10)  #Destroy the monitor after ten seconds
    actMon.destroy()

# Release the component
    simpleClient.releaseComponent("ASM_CPP_LOOP") 

except Exception, e:
    print "Sorry, I expected there to be a Asm in the system and"
    print "there isn't."
    print "The exception was:", e

