/*******************************************************************************
*    ALMA - Atacama Large Millimiter Array
*    (c) Associated Universities Inc., 2002 *
*    (c) European Southern Observatory, 2002
*    Copyright by ESO (in the framework of the ALMA collaboration)
*    and Cosylab 2002, All rights reserved
*
*    This library is free software; you can redistribute it and/or
*    modify it under the terms of the GNU Lesser General Public
*    License as published by the Free Software Foundation; either
*    version 2.1 of the License, or (at your option) any later version.
*
*    This library is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*    Lesser General Public License for more details.
*
*    You should have received a copy of the GNU Lesser General Public
*    License along with this library; if not, write to the Free Software
*    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*
*
*
* "@(#) $Id: acsVltMountNotifyImpl.cpp,v 1.1 2004/01/30 16:17:20 dfugate Exp $"
*
*/
 
#include <acsVltMountNotifyImpl.h>

/* ----------------------------------------------------------------*/
/** Function designed to do something useful with MountEventData's
 *  received from the ACSVLT_MOUNT::MOUNT_CHANNEL channel. This will be 
 *  passed to the macro responsible for initializing SimpleConsumer objects 
 *  used in the constructor of MountNotifyImpl.
 *  
 *  @param joe A MountEventData describing some command sent to a mount device
 *  @return void
 *  @htmlonly
 *  <br><br>
 *  @endhtmlonly
 */
void myHandlerFunction(ACSVLT_MOUNT::MountEventData joe)
{
    cout << "The commanded Az/El received by this consumer are:" << joe.Azimuth << "," << joe.Elevation << endl;
}
/* ----------------------------------------------------------------*/
MountNotifyImpl::MountNotifyImpl(PortableServer::POA_ptr poa, const ACE_CString &_name) :
    ACSComponentImpl(poa, _name),
    m_MountSupplier_p(0),
    m_simpConsumer_p(0)
{
    // ACS_TRACE is used for debugging purposes
    ACS_TRACE("::MountNotifyImpl::MountNotifyImpl");

    // Handle supplier creation here.
    // - m_MountSupplier_p is SimpeSupplier pointer
    // - ACSVLT_MOUNT::MountEventData is the event that will be published
    // - ACSVLT_MOUNT::MOUNT_CHANNEL is the name of the channel these events will be published too
    ACS_NEW_SIMPLE_SUPPLIER(m_MountSupplier_p, ACSVLT_MOUNT::MountEventData, ACSVLT_MOUNT::MOUNT_CHANNEL);

    // Handle consumer creation here.
    // - m_simpConsumer_p is a SimpleConsumer pointer
    // - ACSVLT_MOUNT::MountEventData is the event that will be consumed
    // - ACSVLT_MOUNT::MOUNT_CHANNEL is the name of the channel these events will come from
    // - myHandlerFunction is the function that will be automatically invoked each time an event is received
    ACS_NEW_SIMPLE_CONSUMER(m_simpConsumer_p, ACSVLT_MOUNT::MountEventData, ACSVLT_MOUNT::MOUNT_CHANNEL, myHandlerFunction);

    //Let the channel know we are ready to begin processing events.
    //After consumerReady has been invoked on the Consumer object, we 
    //have very little control over when myHandlerFunction is invoked.
    m_simpConsumer_p->consumerReady();
}
/* ----------------------------------------------------------------*/
MountNotifyImpl::~MountNotifyImpl()
{
    // ACS_TRACE is used for debugging purposes
    ACS_TRACE("::MountNotifyImpl::~MountNotifyImpl");
    ACS_DEBUG_PARAM("::MountNotifyImpl::~MountNotifyImpl", "Destroying %s...", name());

    // clean-up associated with the supplier object
    if (m_MountSupplier_p != 0)
	{
	m_MountSupplier_p->disconnect();
	m_MountSupplier_p=0;
	}

    // clean-up associated with the consumer object
    if (m_simpConsumer_p != 0)
	{
	m_simpConsumer_p->disconnect();
	m_simpConsumer_p=0;
	}
}
/* --------------------- [ CORBA interface ] ----------------------*/
void 
MountNotifyImpl::objfix (CORBA::Double az,
		    CORBA::Double elev)
    throw (CORBA::SystemException)
{
    cout << "Received objfix command. Az: " << az << " El: " << elev << endl;
    
    //Create the data to be published on the event channel
    ACSVLT_MOUNT::MountEventData data;
    data.Azimuth = az;
    data.Elevation = elev;
    
    //Publish the data to the event channel
    m_MountSupplier_p->publishData(data);
}

/* --------------- [ MACI DLL support functions ] -----------------*/
#include <maciACSComponentDefines.h>
MACI_DLL_SUPPORT_FUNCTIONS(MountNotifyImpl)
/* ----------------------------------------------------------------*/


/*___oOo___*/



