/*
 * VisualACSApplication.java
 *
 * Created on February 6, 2004, 10:19 AM
 */
package VisualACSApplication;

/**
 *
 * @author  almausr1
 */

import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;

import com.cosylab.gui.framework.Desktop;
import com.cosylab.gui.framework.Launcher;
import com.cosylab.gui.framework.LauncherEnvironment;

import abeans.pluggable.acs.ACSAbeansEngine;
import abeans.pluggable.acs.maci.settings.ACSPlugSettingsPlugIn;

import com.cosylab.abeans.*;
import com.cosylab.abeans.plugins.*;
import com.cosylab.gui.plugins.*;

/**
 * Template for ACS Visual Abeans Applications.
 */
public class VisualACSApplication extends AbeansLaunchable {
    
    /**
     * ACS Abeans engined used by this application.
     */
    private ACSAbeansEngine engine;
    
    /**
     * Creates a new instance of this class. The default no-arg constructor
     * may be used only by visual builders to instantiate an instance of
     * launchable panel. During run-time spcific constructor must be used.
     * @see com.cosylab.abeans.AbeansLaunchable
     */
    public VisualACSApplication() {
        super();
    }
    
    /**
     * Creates a new instance of this class that will reside in a <code>JFrame</code> container.
     * @see com.cosylab.abeans.AbeansLaunchable
     */
    public VisualACSApplication(
    Launcher launcher,
    LauncherEnvironment env,
    JFrame owner) {
        super(launcher, env, owner);
    }
    
    /**
     * Creates a new instance of this class that will reside inside a <code>JInternalFrame</code>.
     * @see com.cosylab.abeans.AbeansLaunchable
     */
    public VisualACSApplication(
    Launcher launcher,
    LauncherEnvironment env,
    Desktop desk,
    JInternalFrame owner) {
        super(launcher, env, desk, owner);
    }
    
    /**
     * Creates a new instance of this class that will reside inside an applet in a web browser.
     * @see com.cosylab.abeans.AbeansLaunchable
     */
    public VisualACSApplication(
    Launcher launcher,
    LauncherEnvironment env,
    JApplet owner) {
        super(launcher, env, owner);
    }
    
    /**
     * @see com.cosylab.abeans.AbeansLaunchable#getAbeansEngine()
     */
    public AbeansEngine getAbeansEngine() {
        if (engine == null)
            engine = new ACSAbeansEngine(getClass().getName());
        return engine;
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        mount21 = new alma.ACSVLT_MOUNT.abeans.Mount();
        jButton1 = new javax.swing.JButton();
        singleAbeanSelector1 = new com.cosylab.abeans.SingleAbeanSelector();
        doubleNumberField1 = new com.cosylab.abeans.displayers.DoubleNumberField();
        doubleNumberField2 = new com.cosylab.abeans.displayers.DoubleNumberField();
        gauger1 = new com.cosylab.abeans.displayers.Gauger();
        jButton2 = new javax.swing.JButton();
        cmdAz = new javax.swing.JTextField();
        cmdAlt = new javax.swing.JTextField();

        jButton1.setText("jButton1");

        setLayout(new java.awt.GridLayout(0, 1));

        singleAbeanSelector1.setAbean(mount21);
        add(singleAbeanSelector1);

        doubleNumberField1.setDoubleProperty(mount21.getActEl());
        add(doubleNumberField1);

        doubleNumberField2.setDoubleProperty(mount21.getActAz());
        add(doubleNumberField2);

        gauger1.setDoubleProperty(mount21.getActAzSpeed());
        add(gauger1);

        jButton2.setText("OBJFIX");
        jButton2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                Objfix(evt);
            }
        });

        add(jButton2);

        cmdAz.setText("jTextField1");
        add(cmdAz);

        cmdAlt.setText("jTextField2");
        add(cmdAlt);

    }//GEN-END:initComponents

    private void Objfix(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_Objfix
        // Add your handling code here:
        float az = 0;
        float alt = 0;
        
        try {
            az  = Float.parseFloat(cmdAz.getText());
            alt = Float.parseFloat(cmdAlt.getText());
        } catch (Exception e) {return;}
        
        try {
            mount21.objfix(az, alt);
        } catch (Exception e) {}
    }//GEN-LAST:event_Objfix
    
    /**
     * This method is called by the Abeans framework at initialization.
     */
    public void userInitializeGUI() {
        initComponents();
        getSystemPane().setPreferredSize(getPreferredSize());
    }
    
    /**
     * The main entry point for every Java application.
     */
    public static void main(String args[]) {
        AbeansLaunchable.launch(VisualACSApplication.class, args);
    }
    
    /**
     * This method initializes the standard Abeans plugins.
     */
    public void userInitializePlugIns()	{
        try
 {
     installPlugIn(AbeansSystemMenuPlugIn.class);
     installPlugIn(CosyStandardActionsPlugIn.class);
     installPlugIn(AboutPlugIn.class);
     installPlugIn(AbeansStandardActionsPlugIn.class);
     installPlugIn(VitragePlugIn.class);
     installPlugIn(ACSPlugSettingsPlugIn.class);
     
     // uncomment following line(s) to get plugin(s) installed at startup
     // installPlugIn(AbeansExceptionPanelPlugIn.class);
     // installPlugIn(TreeBrowserPlugIn.class);
     // installPlugIn(LoggingPlugIn.class);
     // installPlugIn(ReportAreaPlugIn.class);
        } catch (Exception e)
 {
     e.printStackTrace();
        }
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTextField cmdAlt;
    private javax.swing.JTextField cmdAz;
    private com.cosylab.abeans.displayers.DoubleNumberField doubleNumberField1;
    private com.cosylab.abeans.displayers.DoubleNumberField doubleNumberField2;
    private com.cosylab.abeans.displayers.Gauger gauger1;
    private javax.swing.JButton jButton1;
    private javax.swing.JButton jButton2;
    private alma.ACSVLT_MOUNT.abeans.Mount mount21;
    private com.cosylab.abeans.SingleAbeanSelector singleAbeanSelector1;
    // End of variables declaration//GEN-END:variables
}


