#ifndef acsVltMountNotifyImpl_h
#define acsVltMountNotifyImpl_h
/*******************************************************************************
*    ALMA - Atacama Large Millimiter Array
*    (c) European Southern Observatory, 2002
*    Copyright by ESO (in the framework of the ALMA collaboration)
*    and Cosylab 2002, All rights reserved
*
*    This library is free software; you can redistribute it and/or
*    modify it under the terms of the GNU Lesser General Public
*    License as published by the Free Software Foundation; either
*    version 2.1 of the License, or (at your option) any later version.
*
*    This library is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*    Lesser General Public License for more details.
*
*    You should have received a copy of the GNU Lesser General Public
*    License along with this library; if not, write to the Free Software
*    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*
*
* "@(#) $Id: acsVltMountNotifyImpl.h,v 1.1 2004/01/30 16:17:20 dfugate Exp $"
*
*/

#ifndef __cplusplus
#error This is a C++ include file and cannot be used from plain C
#endif

#include <acscomponentImpl.h>
#include <acsVltMountS.h>

///In this example, events are published to a channel implying we need this header
#include <acsncSimpleSupplier.h>
///In this example, events are also consumed implying we need this header
#include <acsncSimpleConsumer.h>

using namespace acscomponent;


/** @file acsVltMountNotifyImpl.h
 */

/** @defgroup ACSVLTMOUNTNOTIFYDOC MountNotify
 *  @{
 * @htmlonly
<hr size="2" width="100%">
<div align="left">
<h2>Description</h2>
The class MountNotify is identical to Mount1 in nearly all aspects except:
<ul>
  <li>it publishes and consumes data from an event channel using the ACS event channel API.</li>
  <li>exception handling is not used.</li>
</ul>
<br>
<br>
<h2>What can I gain from this example?</h2>
<ul>
  <li>an example derived from the ACS::Component IDL interface.</li>
  <li>understanding of synchronous method implementation.</li>
  <li>publishing events (in the form of user-defined IDL structs) to consumers.</li>
  <li>processing events (in the form of user-defined IDL structs) sent by suppliers.</li>
</ul>
<br>
<br>
<h2>Links</h2>
<ul>
  <li><a href="classMountNotify.html">MountNotify Class Reference</a></li>
  <li><a href="interfaceMOUNT__ACS_1_1MountNotify.html">MountNotify IDL Documentation</a></li>
</ul>
</div>
 * @endhtmlonly
 * @}
 */

/** @class MountNotify
 * The class MountNotify is identical to Mount1 except that in this case, it supplies/consumes
 * events from an event channel.
 * @version "@(#) $Id: acsVltMountNotifyImpl.h,v 1.1 2004/01/30 16:17:20 dfugate Exp $"
 */
class MountNotifyImpl: public virtual ACSComponentImpl,
		  public virtual POA_ACSVLT_MOUNT::MountNotify
{
  public:
     /**
     * Constructor
     * Nearly identical to the Mount1 C++ class's implementation except that 
     * it instantiates both event supplier and consumer objects.
     * @param poa Poa which will activate this and also all other components. 
     * @param name component's name.
     */
    MountNotifyImpl(PortableServer::POA_ptr poa, const ACE_CString &name);
    
    /**
     * Destructor
     * Nearly identical to the Mount1 C++ class's implementation except that 
     * it destroys the event supplier and consumer objects.
     */
    virtual ~MountNotifyImpl();
    
    /**
     * (Pre)sets a new non-moving position for the antenna.
     * The position coordinates are given in azimuth and elevation.
     * The actual az and elev values are written to the properties
     * cmdAz, cmdEl, actAz and actEl. Nearly identical to the Mount1 C++
     * class's implementation except that just before this method returns
     * control, it publishes an event to a particular channel and exception
     * handling is not used here.
     *
     * @param az        position azimuth (degree)
     * @param elev      position elevation (degree)
     * @return void
     * @htmlonly
     * <br><hr>
     * @endhtmlonly
     */    
    virtual void 
    objfix (CORBA::Double az,
	    CORBA::Double elev)
	throw (CORBA::SystemException);

  private:

    /**
     *  This is the Supplier class used to publish data to the event channel.
     *  The templated parameter is the type of event that will be sent.
     */
    nc::SimpleSupplier<ACSVLT_MOUNT::MountEventData> *m_MountSupplier_p;


    /**
     *  This is the Consumer class used to consumer data from the event channel.
     *  The templated parameter is the type of event that will be subscribed
     *  to.
     */
    nc::SimpleConsumer<ACSVLT_MOUNT::MountEventData> *m_simpConsumer_p;
    
    /**
     * ALMA C++ coding standards state copy operators should be disabled.
     */
    void operator=(const MountNotifyImpl&);
};

#endif /*!acsVltMountNotifyImpl_H*/



