#ifndef acsVltMountLoopImpl_h
#define acsVltMountLoopImpl_h
/*******************************************************************************
*    ALMA - Atacama Large Millimiter Array
*    (c) European Southern Observatory, 2002
*    Copyright by ESO (in the framework of the ALMA collaboration)
*    and Cosylab 2002, All rights reserved
*
*    This library is free software; you can redistribute it and/or
*    modify it under the terms of the GNU Lesser General Public
*    License as published by the Free Software Foundation; either
*    version 2.1 of the License, or (at your option) any later version.
*
*    This library is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*    Lesser General Public License for more details.
*
*    You should have received a copy of the GNU Lesser General Public
*    License along with this library; if not, write to the Free Software
*    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*
*
* "@(#) $Id: acsVltMountLoopImpl.h,v 1.1 2004/01/28 11:20:01 bjeram Exp $"
*
*/

#ifndef __cplusplus
#error This is a C++ include file and cannot be used from plain C
#endif

#include <acsVltMountImpl.h>

/** @file acsVltMountImpl.h
 */

/** @defgroup ACSVLTMOUNTDOC Mount
 *  @{
 * @htmlonly
<hr size="2" width="100%">
<div align="left">
<h2>Description</h2>
The class Mount simulates the behaviour of an antenna interface.
&nbsp;It provides only one synchronous methods:
objfix(...). &nbsp;
<br>
<br>
<h2>What can I gain from this example?</h2>
<ul>
  <li>an example derived from the ACS::Component IDL interface.</li>
  <li>understanding of synchronous method implementation.</li>
</ul>
<br>
<br>
<h2>Links</h2>
<ul>
  <li><a href="classMount.html">Mount Class Reference</a></li>
  <li><a href="interfaceMOUNT__ACS_1_1Mount.html">Mount IDL Documentation</a></li>
  <li>Mount CDB XML Schema</li>
</ul>
</div>
 * @endhtmlonly
 * @}
 */

/** @class Mount
 * The class Mount is a basic example of a component and simulates the behaviour of an antenna interface.
 * It provides one asynchronous methods: objfix.  The methods only writes the data into 
 * virtual properties.
 * @version "@(#) $Id: acsVltMountLoopImpl.h,v 1.1 2004/01/28 11:20:01 bjeram Exp $"
 */
class MountLoopImpl: public MountImpl
{
  public:
     /**
     * Constructor
     * @param poa Poa which will activate this and also all other components. 
     * @param name component's name. This is also the name that will be used to find the
     * configuration data for the component in the Configuration Database.
     */
    MountLoopImpl(PortableServer::POA_ptr poa, const ACE_CString &name);
    
    /**
     * Destructor
     */
    virtual ~MountLoopImpl();
    
    

  private:
    
    /**
     * Control loop
     * This method spawns a BACI thread which is used to see if the reference 
     * position and actual position have changed.  If so, it implements the move.  Also,
     * this method is called at construction time by the component's thread manager.
     * @param param parameters
     * @return void
     * @htmlonly
     * <br><hr>
     * @endhtmlonly
     */
    static void 
    positionControl(void *param_p);
    
    /**
     * ALMA C++ coding standards state copy operators should be disabled.
     */
    void operator=(const MountImpl&);

};

#endif /*!acsVltMountImpl_H*/






