package alma.car;



import alma.ACSErr.CompletionHolder;
import alma.ACS.ROdouble;
import alma.TESTIDL_CAR.CarControl;
import alma.TESTIDL_CAR.CarControlHelper;
import alma.acs.component.client.ComponentClientTestCase;

public class CarTest extends ComponentClientTestCase {

	public static final String CARCONTROL_INSTANCE = "PORSCHE-4043";
	private CarControl carControl;
	
	public CarTest(String name) throws Exception {
		super(name);
	}

	protected void setUp() throws Exception {
		super.setUp();
		
		org.omg.CORBA.Object compObj = 
			getContainerServices().getComponent(CARCONTROL_INSTANCE);
		
		carControl = CarControlHelper.narrow(compObj);
	}

	protected void tearDown() throws Exception {
		getContainerServices().releaseComponent(CARCONTROL_INSTANCE);
		super.tearDown();
	}
	
	public void testCarStartStop() {
		assertNotNull(carControl);
		carControl.accelerate(0.2);


		alma.ACS.ROdouble actSpeed = carControl.actSpeed();
		assertNotNull("actSpeed property of carControl not null", actSpeed);

		CompletionHolder compHolder = new CompletionHolder();

		double speed = actSpeed.get_sync(compHolder);
		assertEquals(60.0, speed, 1E-6);
		
		carControl.brake(true);
		assertEquals(0.0, actSpeed.get_sync(compHolder), 1E-6);
	}
}
