-------------------------------------------------------
-- Design Name : rx_ctrl_8b10b 
-- File Name   : rx_ctrl_8b10b.vhd
-- Function    : controlling the 8b10b reception
-- Coder       : K.-H. Sulanke, DESY
-- Date        : 2019-12-16
-------------------------------------------------------
-- 2019-12-16, half duplex arbitration implemented

library ieee;
    use ieee.std_logic_1164.all;

entity rx_ctrl_8b10b is
   port(
        com_reset              :in  std_logic;   -- communication com_reset
        com_clk                :in  std_logic;   -- communication clock
        rx_quiet               :in  std_logic;   -- no signal, line is quiet
        ena_rx                 :in  std_logic;   --
        rx_done                :out std_logic;   -- handshake signal with ena_rx
        dec_8b10b_out          :in  std_logic_vector (7 downto 0); --
        dec_8b10b_valid        :in  std_logic;   --
        dec_8b10b_ko           :in  std_logic;   -- decoder output is comma
        STF_COMMA              :in  std_logic_vector (7 downto 0); -- start of frame comma
        EOF_COMMA              :in  std_logic_vector (7 downto 0);  -- end of frame comma        
        rx_fifo_almost_full    :in  std_logic;
        rx_fifo_wr_en          :out std_logic   -- pulse of one clock length
       );
end entity;

architecture rx_ctrl_8b10b_arch of rx_ctrl_8b10b is

 type state_type is (RX_IDLE, RX_STF, RX_DATA, RX_FWR, RX_WAIT, RX_EOF);
	signal state: state_type := RX_IDLE;
  
  signal stf     : std_logic_vector (7 downto 0); 
  signal eof     : std_logic_vector (7 downto 0); 
 
 begin

    stf       <= STF_COMMA ;
    eof       <= EOF_COMMA ;


   rx_sm: process (com_clk)
	   begin
	  sync: if (rising_edge(com_clk)) then
         
     reset_if: if (ena_rx = '0') then
            state         <= RX_IDLE;
            rx_done       <= '0';
          else
	--		sm_ena : if (dec_8b10b_valid ='1') then
    
			sm: case (state) is
         when RX_IDLE =>
            rx_done       <= '0';
            rx_fifo_wr_en <= '0';
			      if    (dec_8b10b_ko = '1') and (dec_8b10b_valid ='1') and (dec_8b10b_out = stf) then
			        state          <= RX_STF;
			      elsif (dec_8b10b_ko = '1') and (dec_8b10b_valid ='1') and (dec_8b10b_out = eof) then
			        state          <= RX_EOF;  
            end if;  
 
         when RX_STF =>
            if     (dec_8b10b_ko = '1') and (dec_8b10b_valid ='1') and (dec_8b10b_out = eof) then
			       state         <= RX_EOF;
            elsif  (dec_8b10b_ko = '0') and (dec_8b10b_valid ='1') then
             rx_fifo_wr_en <= '1';
			       state         <= RX_FWR;
            end if;
            
         when RX_FWR =>
             rx_fifo_wr_en <= '0';
		     state         <= RX_WAIT;--RX_DATA;

         when RX_WAIT => -- i guess, this state is not really needed
             state         <= RX_DATA;			       

         when RX_DATA =>
            if     (dec_8b10b_ko = '1') and (dec_8b10b_valid ='1')  and (dec_8b10b_out = eof) then
			       state         <= RX_EOF;
--            elsif  (dec_8b10b_ko = '1') and (dec_8b10b_valid ='1')  and (dec_8b10b_out = stf) then
--			       state         <= RX_STF;
            elsif  (dec_8b10b_ko = '0') and (dec_8b10b_valid ='1') then
                   rx_fifo_wr_en <= '1';
			       state         <= RX_FWR;             
            end if;              

         when RX_EOF =>
            if  rx_quiet = '1' then
               rx_done       <= '1';
            end if;
  
        end case sm;
--    end if sm_ena;
   end if reset_if;
  end if sync;
 end process rx_sm;
 
end architecture rx_ctrl_8b10b_arch;
