-------------------------------------------------------------------------------
-- Design Name : mb_clk_sync
-- File Name   : mb_clk_sync.vhd
-- Device      : Spartan 7, XC7S25FTGB196-2
-- Function    : generate the mainboard clock and sync signal
-- Coder       : K.-H. Sulanke, DESY, 2019-02-27
-------------------------------------------------------------------------------

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.numeric_std.all;

library UNISIM ;
use UNISIM.vcomponents.all;

ENTITY mb_clk_sync IS
   PORT
   (
      fpga_clk_fbck : in  std_logic; -- feeded back 50 MHz clock
      fpga_clk_p    : out std_logic; --  mainboard fpga clock
      fpga_clk_n    : out std_logic; --     
      fpga_snc_p    : out std_logic; --  mainboard 1pps sync pulse of one fpga clock length
      fpga_snc_n    : out std_logic; -- 
      time_stamp    : out std_logic_vector(47 downto 0) -- 
    --time_stamp    : out natural range 0 to 2**48-1 -- 
    );
END mb_clk_sync;

Architecture mb_clk_sync_arch of mb_clk_sync is

  signal fpga_clk_nd   : std_logic;    -- 

  signal sync_pulse    : std_logic;    --
  signal time_stamp_ct : natural range 0 to 49_999_999;--2**48 -1;  -- synchronous to fpga_clk

begin
 
 FPGA_CLK_GEN: process (fpga_clk_fbck)
    begin                           -- do power on reset, just once !
     if rising_edge(fpga_clk_fbck) then   
      if (fpga_clk_nd ='1') then
        fpga_clk_nd <= '0';
      else
        fpga_clk_nd <= '1';
      end if;  
    end if; -- rising_edge(mb_clkx2_nd)
   end process FPGA_CLK_GEN;      

   SYNC_PULSE_GEN: process (fpga_clk_fbck)
    begin                           -- do power on reset, just once !
     if rising_edge(fpga_clk_fbck) then
       if (time_stamp_ct = 49_999_998) or (time_stamp_ct = 49_999_999) then
        sync_pulse    <= '1';
       else
        sync_pulse    <= '0';
       end if; 
       if (time_stamp_ct = 49_999_999) then --X"2FAF080" then -- get 1pps from 50 MHz
        time_stamp_ct <= 0;
       else
        time_stamp_ct <= time_stamp_ct + 1;
       end if;  
    end if; -- rising_edge(fpga_clkc_fbck)
   end process  SYNC_PULSE_GEN;      
  
 FPGA_CLK_OBUFDS_inst : OBUFDS
   generic map (
    IOSTANDARD => "DEFAULT",
    SLEW => "fast") 
   port map 
    (
     O  => fpga_clk_p, -- Diff_p output (connect directly to top-level port)
     OB => fpga_clk_n, -- Diff_n output (connect directly to top-level port)
     I  => fpga_clk_nd -- Buffer input
    );

  FPGA_SNC_OBUFDS_inst : OBUFDS
   generic map (
    IOSTANDARD => "DEFAULT", 
    SLEW => "fast") 
   port map 
    (
     O  => fpga_snc_p, -- Diff_p output (connect directly to top-level port)
     OB => fpga_snc_n, -- Diff_n output (connect directly to top-level port)
     I  => sync_pulse -- Buffer input
    );
  
  time_stamp <=  std_logic_vector(to_unsigned(time_stamp_ct, time_stamp'length));
  
END mb_clk_sync_arch;
