-------------------------------------------------------
-- Design Name : half_duplex_ctrl_icm 
-- File Name   : half_duplex_ctrl_icm.vhd
-- Function    : controlling rx / tx arbitration
-- Coder       : K.-H. Sulanke, DESY
-- Date        : 2019-12-14
-------------------------------------------------------
library ieee;
    use ieee.std_logic_1164.all;
    use ieee.std_logic_unsigned.all;

entity half_duplex_ctrl_icm is
   port(
        com_reset          : in  std_logic;   -- communication com_reset
        com_clk            : in  std_logic;   -- communication clock
        tx_done            : in  std_logic;   --
        rx_done            : in  std_logic;   -- last reception finished 
        ena_tx             : out std_logic;   -- initiates sending of data or token
        ena_rx             : out std_logic;   -- initiates receiving of data or token
        rx_quiet           : in  std_logic;    -- rx, no signal on the line
        rx_stf             : in  std_logic   -- start of frame received 
       );
end entity;

architecture half_duplex_ctrl_icm_arch of half_duplex_ctrl_icm is

  constant MAX_CABLE_DELAY  : natural := 40; -- 36us is  ~ 2x3000m cable delay
  constant POWER_UP_DELAY   : natural :=  5;--50;--1023; -- time before first ena_tx after power on
  
   
  signal timer_reset   : std_logic;              -- 
  signal clk_ct        : natural range 0 to 59;  -- 60 clock 60MHz ticks, to get a us tick
  signal us            : std_logic;               -- one clock length tick
  signal us_ct         : natural range 0 to POWER_UP_DELAY;
  signal time_out      : std_logic; 
   
type state_type is (POWER_UP,  RX, TX); --RX_WAIT,
	signal state: state_type := POWER_UP;
 
 begin
 
   get_us_ticks: process (com_clk)
    begin
     if (rising_edge(com_clk)) then	           
       if (timer_reset = '1') then
        clk_ct <= 0;
        us     <= '0';
       else
        if clk_ct < 59 then
         clk_ct <= clk_ct + 1;
         us     <= '0';
        else
         clk_ct <= 0;
         us     <= '1';
        end if; -- clk_ct < 59
       end if; -- (com_reset = '1')
     end if; -- (rising_edge(com_clk))
    end process  get_us_ticks;
          
  timer: process (com_clk)
    begin
     if (rising_edge(com_clk)) then	           
       if (timer_reset = '1') then
        us_ct    <= 0;
        time_out <= '0';
       elsif us = '1' then
        if us_ct < POWER_UP_DELAY then
         us_ct <= us_ct + 1;
        else
         us_ct <= 0;
        end if;
        if us_ct = MAX_CABLE_DELAY then         
         time_out <= '1';
        else
         time_out <= '0';  
        end if; 
       end if; -- (timer_reset = '1')
     end if; -- (rising_edge(com_clk))
    end process timer;
                              
   arb_sm: process (com_clk)
	   begin
	  if (rising_edge(com_clk)) then	           
       if (com_reset = '1') then
       
            state           <= POWER_UP;
            timer_reset     <= '1'; 
            ena_tx          <= '0';
            ena_rx          <= '0';
         else
			sm: case (state) is

       when POWER_UP =>  
            ena_tx          <= '0';
            ena_rx          <= '0';
            timer_reset     <= '0';
            if us_ct = POWER_UP_DELAY then
              timer_reset   <= '1';      
  			  state         <= RX;
             end if;

--       when RX_WAIT =>
--            ena_tx          <= '0';
--            ena_rx          <= '1';
--           -- timer_reset     <= '0';  
--            if (rx_stf = '1') then       
--  			  state         <= RX;
--   			--  timer_reset   <= '1';
--            end if;


         when RX =>
            ena_tx          <= '0';
            ena_rx          <= '1';
           -- timer_reset     <= '0';  
            if (rx_done = '1') then --or (rx_quiet = '1') then       
  			  state         <= TX;
   			--  timer_reset   <= '1';
            end if;

			              
         when TX =>  
            ena_tx          <= '1';
            ena_rx          <= '0';
            if tx_done = '1' then       
  			  state         <= RX;
            end if;
 
         end case sm;
 
        
   end if; -- if (com_reset = '1')
  end if ;--if (rising_edge(com_clk))
 end process arb_sm;
 
end architecture half_duplex_ctrl_icm_arch;
