-------------------------------------------------------
-- Design Name : com_dac_enc 
-- File Name   : com_dac_enc.vhd
-- Function    : com_dac input signal gen. from serial data in
-- Coder       : K.-H. Sulanke, DESY
-- Date        : 2019-10-08
-- Revision    : 05
-------------------------------------------------------
-- encoding falling edges only to encode a '1', as bipolar pulse

library ieee;
    use ieee.std_logic_1164.all;
    use ieee.std_logic_unsigned.all;
    use ieee.numeric_bit.all;
    use ieee.std_logic_arith.all;
Library UNISIM;
    use UNISIM.vcomponents.all;
    
entity com_dac_enc is
   port(
        reset           : in  std_logic;
        clk             : in  std_logic;
        baudrate_adj    : in  std_logic_vector(1 downto 0);
        sdin            : in  std_logic; -- serial data input
        com_dac_quiet   : in  std_logic; -- get zero baseline value, when comm. is inactive
        com_dac_in      : out std_logic_vector (11 downto 0); 
        com_dac_clock   : out std_logic
       );
end entity;

architecture com_dac_enc_arch of com_dac_enc is
 
  constant COM_DAC_MAX    : std_logic_vector  :=  X"fff"; -- about 1.5V at transformer 
  
  signal com_dac_din      : std_logic_vector (11 downto 0);
  signal com_dac_clock_nd : std_logic;

  signal pulse_length     : integer range 0 to 127;
  signal half_pulse_length : integer range 0 to 63;
  
  signal ct                : natural range 0 to 127;
 
 begin
 
   get_pulse_length: process (clk) -- amount of clocks per bit
   begin
    if rising_edge(clk) then
     if reset = '1' then
      pulse_length <= 60; half_pulse_length <= 30;
     else 
       if ct = 0 then            -- for synchronized changing of the baudrate    
        case baudrate_adj is
         when B"00"   => pulse_length <=  60 ; half_pulse_length <=   30 ; --  1000_000 baud @ 60MHz clk 
         when B"01"   => pulse_length <=  40 ; half_pulse_length <=   20 ; --  1500_000 baud @ 60MHz clk 
         when B"10"   => pulse_length <=  30 ; half_pulse_length <=   15 ; --  2000_000 baud @ 60MHz clk 
         when B"11"   => pulse_length <=  20 ; half_pulse_length <=   10 ; --  3000_000 baud @ 60MHz clk 
 
         when others => pulse_length <= 60; half_pulse_length <=    30 ;    
        end case;
       end if; -- ct = 0
      end if; -- reset = '1' 
     end if; -- rising_edge(clk)   
   end process get_pulse_length; 

  counter: process (clk)
    begin
     if(rising_edge(clk)) then
      if (com_dac_quiet = '1') then
         ct <= 0;
      else
        if ct < pulse_length-1 then
         ct <= ct + 1;
        else
         ct <= 0;  
        end if;
      end if; -- (com_dac_quiet = '1') 
     end if; --rising_edge(clk) 
    end process counter;      


 com_dac_ctrl: process (clk)
	begin
	 if (rising_edge(clk)) then
      if (com_dac_quiet = '1') then
       com_dac_in  <= X"800"; -- zero level
       com_dac_clock_nd  <= '0';
      else
       if (sdin = '1') then
        if ct  < half_pulse_length then 
         com_dac_in <= X"FFF";
        else
         com_dac_in <= X"000";
        end if;
       else
         com_dac_in <= X"800";
       end if; -- (sdin = '1')
       if (ct = 1) or (ct = half_pulse_length +1) then
        com_dac_clock_nd  <= '1';
       else
        com_dac_clock_nd  <= '0';
       end if;  
      end if; --  (com_dac_quiet = '1')  
     end if;  -- (rising_edge(clk)) 
    end process com_dac_ctrl; 

  com_dac_clock <= com_dac_clock_nd;

 end architecture com_dac_enc_arch;
