-------------------------------------------------------
-- Design Name : icm_tb_01
-- File Name   : icm_tb_01.vhd
-- Function    : UART transmitter test bench
-- Coder       : K.-H. Sulanke, DESY
-- Date        : 2019-12-19
-------------------------------------------------------
library ieee;
    use ieee.std_logic_1164.all;
    use ieee.std_logic_unsigned.all;
    use ieee.numeric_std.all;
 
entity icm_tb_01 is
end icm_tb_01;

architecture behavior of icm_tb_01 is
  
component icm_top_005 is 
port(    
      -- ************************ Bank #14, VCCO = 1.8V  ****************************************************
      FPGA_CLK_P    : out std_logic;  -- DIFF_SSTL18_I, clock, delivered to the mainboard
      FPGA_CLK_N    : out std_logic;  --
      FPGA_CLK      : out std_logic;  -- LVCMOS18, copy of the differential clock, delivered to the mainboard
      FPGA_CLK_FBCK : in  std_logic;  -- LVCMOS18, FPGA_CLK feeded back 
      FPGA_SNC_P    : out std_logic;  -- DIFF_SSTL18_I, sync pulse, delivered to the mainboard
      FPGA_SNC_N    : out std_logic;  --
      
      FPGA_GPIO_0   : in std_logic;  -- general purpose IO     
      FPGA_GPIO_1   : in std_logic;  --     
      FPGA_GPIO_2   : in std_logic;  --     
      FPGA_GPIO_3   : in std_logic;  --
          
      FPGA_UART_TX  : in  std_logic;  --  driven by mainboard FPGA   
      FPGA_UART_RX  : out std_logic;  --  received by mainboard FPGA     
      FPGA_UART_CTS : out std_logic;  -- 
      FPGA_UART_RTS : in  std_logic;  -- 
      
      STM_USART_TX   : in  std_logic;  --  driven by mainboard MCU   
      STM_USART_RX   : out std_logic;  --  received by mainboard MCU     
      STM_USART_CTS  : out std_logic;  -- 
      STM_USART_RTS  : in  std_logic;  --
       
      STM_BOOT      : out std_logic;  --
                                   
      COM_ADC_D     : in  std_logic_vector(13 downto 0);    -- communication ADC output
      COM_ADC_CSBn  : out std_logic; --
      COM_ADC_SCLK  : out std_logic; --
      COM_ADC_SDIO  : inout std_logic; -- is inout
      COM_ADC_CLK_P : out std_logic;  -- DIFF_SSTL18_I, comm. ADC  clock     
      COM_ADC_CLK_N : out std_logic;  -- 
      
      D00_MOSI      : inout std_logic;  -- 
      D01_DIN       : inout std_logic;  -- 
      D02           : inout std_logic;  -- 
      D03           : inout std_logic;  -- 
      FLASH_CSn     : out std_logic;  -- 
      

      -- ************************ Bank #34, VCCO = 3.3V  ****************************************************
      QOSC_CLK      : in  std_logic;  -- 20 MHz local oscillator
      QOSC_SDA      : out std_logic;  -- I2C DAC for frequency tuning
      QOSC_SCL      : out std_logic;  --
      
      nLED_ENA      : out std_logic;  --
      nRX_LED       : out std_logic;  --
      nTX_LED       : out std_logic;  --
      
      COM_DAC_DB    : out std_logic_vector(11 downto 0);    -- connected to communication DAC
      COM_DAC_CLOCK : out std_logic;  -- 
      COM_DAC_SLEEP : out std_logic;  -- 
           
      USB_TXD       : in  std_logic;  --   
      USB_RXD       : out std_logic;  --       
      USB_CTSn      : out std_logic;  -- 
      USB_RTSn      : in  std_logic;  --
      USB_PWRENn    : in  std_logic;  --
      USB_RESETn    : out std_logic;  --
      
      INTLK_ENA     : out std_logic;  -- 
      INTLK_0       : out std_logic;  -- 
      INTLK_1       : out std_logic;  -- 
      INTLK_2       : out std_logic;  -- 
      INTLK_3       : out std_logic;  -- 

      MB_GPIO0      : out std_logic; -- main board general purpose IO
      MB_GPIO1      : out std_logic;
      MB_GPIO2      : out std_logic;
      MB_GPIO3      : out std_logic;      
      
      MB_ID         : out std_logic; --inout 
      ICM_ID        : out std_logic; --inout
      
      MB_ADR0       : in  std_logic;    -- 
      MB_ADR1       : in  std_logic;    -- 
      MB_ADR2       : in  std_logic;    -- 
 
      TEST_IO_0     : out std_logic;
      TEST_IO_1     : out std_logic;
      TEST_IO_2     : out std_logic;
      TEST_IO_3     : out std_logic;
      
      TERM_FPGA     : out std_logic  -- '1' activates cable termination       
     );
end component icm_top_005 ;

    signal FPGA_CLK_P     : std_logic; 
    signal FPGA_CLK_N     : std_logic; 
    signal FPGA_CLK       : std_logic; 
    signal FPGA_CLK_FBCK  : std_logic; 
    signal FPGA_SNC_P     : std_logic; 
    signal FPGA_SNC_N     : std_logic;   -- 
    signal FPGA_GPIO_0    : std_logic;    -- 3 to select between RS232/485, 4..5 are being used as ADR_SW
    signal FPGA_GPIO_1    : std_logic; 
    signal FPGA_GPIO_2    : std_logic;   --
    signal FPGA_GPIO_3    : std_logic;   --
    signal FPGA_UART_TX   : std_logic;   --
    signal FPGA_UART_RX   : std_logic;   --
    signal FPGA_UART_CTS  : std_logic;   --
    signal FPGA_UART_RTS  : std_logic;   --
    signal STM_USART_TX   : std_logic; 
    signal STM_USART_RX   : std_logic;   --
    signal STM_USART_CTS  : std_logic;   --
    signal STM_USART_RTS  : std_logic;   --
    signal STM_BOOT       : std_logic;   --
    signal COM_ADC_D      : std_logic_vector (13 downto 0);   --
    signal COM_ADC_CSBn   : std_logic;   --
    signal COM_ADC_SCLK   : std_logic; 
    signal COM_ADC_SDIO   : std_logic;   --
    signal COM_ADC_CLK_P  : std_logic;   --
    signal COM_ADC_CLK_N  : std_logic;   --
    signal D00_MOSI       : std_logic;   --
    signal D01_DIN        : std_logic;   --
    signal D02            : std_logic;   --
    signal D03            : std_logic;   --
    signal FLASH_CSn      : std_logic; 
    signal QOSC_CLK       : std_logic := '0';   --
    signal QOSC_SDA       : std_logic;   --
    signal QOSC_SCL       : std_logic;   --
    signal nLED_ENA       : std_logic;   --
    signal nRX_LED        : std_logic;   --
    signal nTX_LED        : std_logic;   --
    signal COM_DAC_DB     : std_logic_vector (11 downto 0); 
    signal COM_DAC_CLOCK  : std_logic;   --
    signal COM_DAC_SLEEP  : std_logic;   --
    signal USB_TXD        : std_logic;   --
    signal USB_RXD        : std_logic;   --
    signal USB_CTSn       : std_logic;   --
    signal USB_RTSn       : std_logic;   --
    signal USB_PWRENn     : std_logic;   --
    signal USB_RESETn     : std_logic; 
    signal INTLK_ENA      : std_logic;   --
    signal INTLK_0        : std_logic;   --
    signal INTLK_1        : std_logic;   --
    signal INTLK_2        : std_logic;   --
    signal INTLK_3        : std_logic;   --
    signal MB_GPIO0       : std_logic;   --
    signal MB_GPIO1       : std_logic; 
    signal MB_GPIO2       : std_logic;   --
    signal MB_GPIO3       : std_logic;   --
    signal MB_ID          : std_logic;   --
    signal ICM_ID         : std_logic;   --
    signal MB_ADR0        : std_logic;   --
    signal MB_ADR1        : std_logic;   --
    signal MB_ADR2        : std_logic; 
    signal TEST_IO_0      : std_logic;   --
    signal TEST_IO_1      : std_logic;   --
    signal TEST_IO_2      : std_logic;   --
    signal TEST_IO_3      : std_logic;   --
    signal TERM_FPGA      : std_logic;   --
 
  component uart is port -- to emulate the USB to UART bridge 
   (
    clk                : in std_logic;
    reset              : in std_logic;

    tx_data_valid      : in  std_logic;                     -- handshake signal with tx_ack
    tx_data_in         : in  std_logic_vector (7 downto 0); -- parallel tx data input
    tx_busy            : out std_logic;                     -- busy with sending a byte
    tx_ack             : out std_logic;                     -- handshake signal with tx_data_valid
    tx_out             : out std_logic;                     -- serial data output

    rx_in              : in  std_logic;                     -- serial data input
    rx_data_out        : out std_logic_vector (7 downto 0); -- parallel rx data output
    rx_data_valid      : out std_logic                      -- single clock length pulse
    );
   end component uart;

   
 -- ext. uart, inputs
  signal uart_clk      : std_logic := '0';
  signal uart_reset    : std_logic                     := 'U';
  signal tx_data_valid : std_logic                     := '0';
  signal rx_in         : std_logic;
  signal tx_data_in    : std_logic_vector (7 downto 0) := (others => 'U');

-- ext. uart, outputs
  signal tx_ack        : std_logic := '0';
  signal tx_out        : std_logic := '0';
  signal tx_busy       : std_logic;
  signal rx_data_out   : std_logic_vector (7 downto 0) := (others => 'U');
  signal rx_data_valid : std_logic;
 
  constant uart_clk_period : time := 33.33 ns; -- 30 MHz system clock
  constant qosc_clk_period : time := 50 ns; -- 20 MHz oscillator
   

begin

  uart_clk  <= not uart_clk after uart_clk_period / 2;
  QOSC_CLK  <= not QOSC_CLK after qosc_clk_period / 2;

  USB_TXD   <= tx_out;  -- external UART connected for serilization / deserialization
  rx_in     <= USB_RXD;  

	
  ICM_comms_test: process
  	
--	 variable message     : string (1 to message_len) := "  DAC  7  0 5 1234  " & cr & lf;

 --   constant TEST_STRG : string := "Started : ""Generate Programming File""." &cr&lf;
    constant TEST_STRG : string := "123456789" &cr&lf;
--    constant TEST_STRG : string := "if (eof_rcvd = '1') or (no_edge_ct = NO_EDGES_TIME_OUT) or (no_comma_ct = NO_COMMA_TIME_OUT) then";
--    constant TEST_STRG : string := "a";
    
  	variable message_len : integer;
  	variable i           : integer;
	variable char        : character;
	variable char_ascii  : integer range 0 to 255;
	variable  byte        : natural range 0 to 255 := 0;
	variable  word        : std_logic_vector(15 downto 0) := X"0000";
	
		   
	begin
  
      --TEST_IO_0 <= '0'; -- com_thr_adj(0)
      --TEST_IO_3 <= '0'; -- com_thr_adj(0)
    
      tx_data_valid     <= '0';
    
      uart_reset <= '1';
      wait for uart_clk_period * 100;
      uart_reset <= '0';
 	  
--    wait until (reset = '1');
--    wait until (reset = '0');
    
	   wait for uart_clk_period * 100;

      
       byte := 189;

	    send_binaries: for i in 1 to 1100 loop
--	       tx_data_in    <= std_logic_vector( to_unsigned ( byte , 8));
	       tx_data_in    <= word(7 downto 0);
	       tx_data_valid <= '1';
	       wait until tx_ack = '1';
	       tx_data_valid <= '0';
	       tx_data_in    <= word(15 downto 8);
	       tx_data_valid <= '1';
	       wait until tx_ack = '1';
	       tx_data_valid <= '0';            
	       --byte := byte + 1;
	       word := word + '1';
	       wait for uart_clk_period *1; -- 
	    end loop send_binaries;
	    tx_data_valid    <= '0';     
      wait for uart_clk_period * 100;   


--      message_len := TEST_STRG'length;
--      tx_data_valid <= '1';
--	    send_test_strg: for i in 1 to message_len loop
--	       -- conversion to ASCII code by getting the position of char
--	       -- in the ASCII table "CHARACTER" 
--	       char          := TEST_STRG(i);
--	       char_ascii    := CHARACTER'pos(char);
--	       tx_data_in    <= std_logic_vector( to_unsigned ( char_ascii, 8));
--	       wait until tx_ack = '1';
--	       wait for uart_clk_period *1; -- 
--	    end loop send_test_strg;
--	    tx_data_valid    <= '0';     
--      wait for uart_clk_period * 100;   

   wait;
  	    
	end process ICM_comms_test;


	    
-- instantiate the units under test (uut)

uart_inst: uart port map
    (
      reset      => uart_reset,
      clk        => uart_clk,
      tx_data_valid   => tx_data_valid,
      tx_data_in => tx_data_in,
      tx_busy    => tx_busy,
      tx_ack     => tx_ack,
      tx_out     => tx_out,
      rx_in      => rx_in,
      rx_data_out   => rx_data_out,
      rx_data_valid => rx_data_valid
     );

   COM_ADC_D <= COM_DAC_DB & B"00";

  icm_top_005_port_map: component icm_top_005
   port map
   (
     FPGA_CLK_P     =>  FPGA_CLK_P     ,
     FPGA_CLK_N     =>  FPGA_CLK_N     ,
     FPGA_CLK       =>  FPGA_CLK       ,
     FPGA_CLK_FBCK  =>  FPGA_CLK       ,
     FPGA_SNC_P     =>  FPGA_SNC_P     ,
     FPGA_SNC_N     =>  FPGA_SNC_N     ,
     FPGA_GPIO_0    =>  FPGA_GPIO_0    ,
     FPGA_GPIO_1    =>  FPGA_GPIO_1    ,
     FPGA_GPIO_2    =>  FPGA_GPIO_2    ,
     FPGA_GPIO_3    =>  FPGA_GPIO_3    ,
     FPGA_UART_TX   =>  FPGA_UART_TX   ,
     FPGA_UART_RX   =>  FPGA_UART_RX   ,
     FPGA_UART_CTS  =>  FPGA_UART_CTS  ,
     FPGA_UART_RTS  =>  FPGA_UART_RTS  ,
     STM_USART_TX   =>  STM_USART_TX   ,
     STM_USART_RX   =>  STM_USART_RX   ,
     STM_USART_CTS  =>  STM_USART_CTS  ,
     STM_USART_RTS  =>  STM_USART_RTS  ,
     STM_BOOT       =>  STM_BOOT       ,
     COM_ADC_D      =>  COM_ADC_D      ,
     COM_ADC_CSBn   =>  COM_ADC_CSBn   ,
     COM_ADC_SCLK   =>  COM_ADC_SCLK   ,
     COM_ADC_SDIO   =>  COM_ADC_SDIO   ,
     COM_ADC_CLK_P  =>  COM_ADC_CLK_P  ,
     COM_ADC_CLK_N  =>  COM_ADC_CLK_N  ,
     D00_MOSI       =>  D00_MOSI       ,
     D01_DIN        =>  D01_DIN        ,
     D02            =>  D02            ,
     D03            =>  D03            ,
     FLASH_CSn      =>  FLASH_CSn      ,
     QOSC_CLK       =>  QOSC_CLK       ,
     QOSC_SDA       =>  QOSC_SDA       ,
     QOSC_SCL       =>  QOSC_SCL       ,
     nLED_ENA       =>  nLED_ENA       ,
     nRX_LED        =>  nRX_LED        ,
     nTX_LED        =>  nTX_LED        ,
     COM_DAC_DB     =>  COM_DAC_DB     ,
     COM_DAC_CLOCK  =>  COM_DAC_CLOCK  ,
     COM_DAC_SLEEP  =>  COM_DAC_SLEEP  ,
     USB_TXD        =>  USB_TXD        ,
     USB_RXD        =>  USB_RXD        ,
     USB_CTSn       =>  USB_CTSn       ,
     USB_RTSn       =>  USB_RTSn       ,
     USB_PWRENn     =>  USB_PWRENn     ,
     USB_RESETn     =>  USB_RESETn     ,
     INTLK_ENA      =>  INTLK_ENA      ,
     INTLK_0        =>  INTLK_0        ,
     INTLK_1        =>  INTLK_1        ,
     INTLK_2        =>  INTLK_2        ,
     INTLK_3        =>  INTLK_3        ,
     MB_GPIO0       =>  MB_GPIO0       ,
     MB_GPIO1       =>  MB_GPIO1       ,
     MB_GPIO2       =>  MB_GPIO2       ,
     MB_GPIO3       =>  MB_GPIO3       ,
     MB_ID          =>  MB_ID          ,
     ICM_ID         =>  ICM_ID         ,
     MB_ADR0        =>  MB_ADR0        ,
     MB_ADR1        =>  MB_ADR1        ,
     MB_ADR2        =>  MB_ADR2        ,
     TEST_IO_0      =>  TEST_IO_0      ,
     TEST_IO_1      =>  TEST_IO_1      ,
     TEST_IO_2      =>  TEST_IO_2      ,
     TEST_IO_3      =>  TEST_IO_3      ,
     TERM_FPGA      =>  TERM_FPGA      
   );
  
 --  TEST_IO12     <= TEST_IO13;
--  (TEST_IO7, TEST_IO5, TEST_IO3, TEST_IO1) <= B"1111"; -- baudrate setting

end architecture behavior;
  